/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.IntegratedFactorAnalysisLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.factorAnalysis.FactorAnalysisOperatorAdaptor;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IntegratedFactorGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private final CompoundParameter factors;
    private final FactorAnalysisOperatorAdaptor adaptor;
    private static final String INTEGRATED_FACTORS_GIBBS = "integratedFactorsGibbsOperator";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getChild(CompoundParameter.class);
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            IntegratedFactorAnalysisLikelihood integratedFactorAnalysisLikelihood = (IntegratedFactorAnalysisLikelihood)xMLObject.getChild(IntegratedFactorAnalysisLikelihood.class);
            double d = xMLObject.getDoubleAttribute("weight");
            return new IntegratedFactorGibbsOperator(compoundParameter, treeDataLikelihood, integratedFactorAnalysisLikelihood, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(CompoundParameter.class), new ElementRule(TreeDataLikelihood.class), new ElementRule(IntegratedFactorAnalysisLikelihood.class), AttributeRule.newDoubleRule("weight")};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return IntegratedFactorGibbsOperator.class;
        }

        @Override
        public String getParserName() {
            return IntegratedFactorGibbsOperator.INTEGRATED_FACTORS_GIBBS;
        }
    };

    IntegratedFactorGibbsOperator(CompoundParameter compoundParameter, TreeDataLikelihood treeDataLikelihood, IntegratedFactorAnalysisLikelihood integratedFactorAnalysisLikelihood, double d) {
        this.setWeight(d);
        this.factors = compoundParameter;
        this.adaptor = new FactorAnalysisOperatorAdaptor.IntegratedFactors(integratedFactorAnalysisLikelihood, treeDataLikelihood);
    }

    @Override
    public String getOperatorName() {
        return INTEGRATED_FACTORS_GIBBS;
    }

    @Override
    public double doOperation() {
        this.adaptor.fireLoadingsChanged();
        this.adaptor.drawFactors();
        for (int i = 0; i < this.adaptor.getNumberOfTaxa(); ++i) {
            for (int j = 0; j < this.adaptor.getNumberOfFactors(); ++j) {
                this.factors.getParameter(i).setParameterValueQuietly(j, this.adaptor.getFactorValue(j, i));
            }
        }
        this.factors.fireParameterChangedEvent();
        return 0.0;
    }
}

