/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ColumnSwapOperator
extends SimpleMCMCOperator {
    private final MatrixParameterInterface matrix;
    private static final String COLUMN_SWAP = "columnSwapOperator";
    private static final String WEIGHT = "weight";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute(ColumnSwapOperator.WEIGHT);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            return new ColumnSwapOperator(matrixParameterInterface, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class), AttributeRule.newDoubleRule(ColumnSwapOperator.WEIGHT)};
        }

        @Override
        public String getParserDescription() {
            return "swaps random columns of a matrix";
        }

        @Override
        public Class getReturnType() {
            return ColumnSwapOperator.class;
        }

        @Override
        public String getParserName() {
            return ColumnSwapOperator.COLUMN_SWAP;
        }
    };

    public ColumnSwapOperator(MatrixParameterInterface matrixParameterInterface, double d) {
        this.setWeight(d);
        this.matrix = matrixParameterInterface;
    }

    @Override
    public String getOperatorName() {
        return COLUMN_SWAP;
    }

    @Override
    public double doOperation() {
        int n = this.matrix.getRowDimension();
        int n2 = this.matrix.getColumnDimension();
        int n3 = MathUtils.nextInt(n2);
        int n4 = MathUtils.nextInt(n2);
        while (n4 == n3) {
            n4 = MathUtils.nextInt(n2);
        }
        for (int i = 0; i < n; ++i) {
            double d = this.matrix.getParameterValue(i, n3);
            double d2 = this.matrix.getParameterValue(i, n4);
            this.matrix.setParameterValueQuietly(i, n3, d2);
            this.matrix.setParameterValueQuietly(i, n4, d);
        }
        this.matrix.fireParameterChangedEvent();
        return 0.0;
    }
}

