/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.distribution.GammaDistributionModel;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedParameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RandomWalkGammaPrecisionGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String OPERATOR_NAME = "randomWalkGammaPrecisionGibbsOperator";
    public static final String DATA = "data";
    public static final String PRECISION = "precision";
    public static final String PRIOR = "prior";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("data", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("precision", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("prior", new XMLSyntaxRule[]{new ElementRule(GammaDistributionModel.class)})};

        @Override
        public String getParserName() {
            return RandomWalkGammaPrecisionGibbsOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getChild(RandomWalkGammaPrecisionGibbsOperator.DATA).getChild(Parameter.class);
            Parameter parameter2 = (Parameter)xMLObject.getChild(RandomWalkGammaPrecisionGibbsOperator.PRECISION).getChild(Parameter.class);
            GammaDistributionModel gammaDistributionModel = (GammaDistributionModel)xMLObject.getChild(RandomWalkGammaPrecisionGibbsOperator.PRIOR).getChild(GammaDistributionModel.class);
            return new RandomWalkGammaPrecisionGibbsOperator(parameter, parameter2, gammaDistributionModel, d);
        }

        @Override
        public String getParserDescription() {
            return "This element returns an operator on the precision parameter of a normal random walk model with gamma prior.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final Distribution prior;
    private final Parameter data;
    private final Parameter precision;
    private double pathParameter = 1.0;

    public RandomWalkGammaPrecisionGibbsOperator(Parameter parameter, Parameter parameter2, Distribution distribution, double d) {
        if (!(distribution instanceof GammaDistribution) && !(distribution instanceof GammaDistributionModel)) {
            throw new RuntimeException("Precision prior must be Gamma");
        }
        this.precision = parameter2;
        this.data = parameter;
        this.prior = distribution;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public double doOperation() {
        double d;
        double d2;
        double d3 = this.prior.mean();
        double d4 = this.prior.variance();
        if (d3 == 0.0) {
            d2 = 0.0;
            d = -0.5;
        } else {
            d2 = d3 / d4;
            d = d3 * d2;
        }
        double d5 = 0.0;
        int n = this.data.getDimension();
        for (int i = 1; i < n; ++i) {
            double d6 = this.data.getParameterValue(i) - this.data.getParameterValue(i - 1);
            d5 += d6 * d6;
        }
        double d7 = d + this.pathParameter * (double)n / 2.0;
        double d8 = d2 + this.pathParameter * 0.5 * d5;
        double d9 = MathUtils.nextGamma(d7, d8);
        this.precision.setParameterValue(0, d9);
        return 0.0;
    }

    @Override
    public void setPathParameter(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid pathParameter value");
        }
        this.pathParameter = d;
    }

    public int getStepCount() {
        return 1;
    }

    public static void main(String[] stringArray) {
        Parameter.Default default_ = new Parameter.Default(new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Transform.LogTransform logTransform = new Transform.LogTransform();
        TransformedParameter transformedParameter = new TransformedParameter(default_, logTransform, true);
    }
}

