/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.JointOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.util.NumberFormatter;
import java.io.PrintStream;

public class OperatorAnalysisPrinter {
    private static final NumberFormatter formatter = new NumberFormatter(8);

    public static void showOperatorAnalysis(PrintStream printStream, OperatorSchedule operatorSchedule, boolean bl) {
        printStream.println();
        printStream.println("Operator analysis");
        printStream.println(formatter.formatToFieldWidth("Operator", 50) + formatter.formatToFieldWidth("Tuning", 9) + formatter.formatToFieldWidth("Count", 11) + formatter.formatToFieldWidth("Time", 9) + formatter.formatToFieldWidth("Time/Op", 9) + formatter.formatToFieldWidth("Pr(accept)", 11) + formatter.formatToFieldWidth("Smoothed_Pr(accept)", 11) + (bl ? "" : " Performance suggestion"));
        for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
            MCMCOperator mCMCOperator = operatorSchedule.getOperator(i);
            if (mCMCOperator instanceof JointOperator) {
                JointOperator jointOperator = (JointOperator)mCMCOperator;
                for (int j = 0; j < jointOperator.getNumberOfSubOperators(); ++j) {
                    printStream.println(OperatorAnalysisPrinter.formattedOperatorName(jointOperator.getSubOperatorName(j)) + OperatorAnalysisPrinter.formattedParameterString(jointOperator.getSubOperator(j)) + OperatorAnalysisPrinter.formattedCountString(mCMCOperator) + OperatorAnalysisPrinter.formattedTimeString(mCMCOperator) + OperatorAnalysisPrinter.formattedTimePerOpString(mCMCOperator) + OperatorAnalysisPrinter.formattedProbString(jointOperator) + OperatorAnalysisPrinter.formattedSmoothedProbString(mCMCOperator) + (bl ? "" : OperatorAnalysisPrinter.formattedDiagnostics(jointOperator, jointOperator.getAcceptanceProbability())));
                }
                continue;
            }
            printStream.println(OperatorAnalysisPrinter.formattedOperatorName(mCMCOperator.getOperatorName()) + OperatorAnalysisPrinter.formattedParameterString(mCMCOperator) + OperatorAnalysisPrinter.formattedCountString(mCMCOperator) + OperatorAnalysisPrinter.formattedTimeString(mCMCOperator) + OperatorAnalysisPrinter.formattedTimePerOpString(mCMCOperator) + OperatorAnalysisPrinter.formattedProbString(mCMCOperator) + OperatorAnalysisPrinter.formattedSmoothedProbString(mCMCOperator) + (bl ? "" : OperatorAnalysisPrinter.formattedDiagnostics(mCMCOperator, mCMCOperator.getAcceptanceProbability())));
        }
        printStream.println();
    }

    private static String formattedOperatorName(String string) {
        return formatter.formatToFieldWidth(string, 50);
    }

    private static String formattedParameterString(MCMCOperator mCMCOperator) {
        String string = "        ";
        if (mCMCOperator instanceof AdaptableMCMCOperator && ((AdaptableMCMCOperator)mCMCOperator).getMode() != AdaptationMode.ADAPTATION_OFF) {
            string = formatter.formatToFieldWidth(formatter.formatDecimal(((AdaptableMCMCOperator)mCMCOperator).getRawParameter(), 3), 8);
        }
        return string;
    }

    private static String formattedCountString(MCMCOperator mCMCOperator) {
        long l = mCMCOperator.getCount();
        return formatter.formatToFieldWidth(Long.toString(l), 10) + " ";
    }

    private static String formattedTimeString(MCMCOperator mCMCOperator) {
        long l = mCMCOperator.getTotalEvaluationTime();
        return formatter.formatToFieldWidth(Long.toString(l), 8) + " ";
    }

    private static String formattedTimePerOpString(MCMCOperator mCMCOperator) {
        double d = mCMCOperator.getMeanEvaluationTime();
        return formatter.formatToFieldWidth(formatter.formatDecimal(d, 2), 8) + " ";
    }

    private static String formattedProbString(MCMCOperator mCMCOperator) {
        double d = mCMCOperator.getAcceptanceProbability();
        return formatter.formatToFieldWidth(formatter.formatDecimal(d, 4), 11) + " ";
    }

    private static String formattedSmoothedProbString(MCMCOperator mCMCOperator) {
        double d = mCMCOperator.getSmoothedAcceptanceProbability();
        return formatter.formatToFieldWidth(formatter.formatDecimal(d, 4), 11) + " ";
    }

    private static String formattedDiagnostics(MCMCOperator mCMCOperator, double d) {
        String string = "good";
        if (d < 0.2) {
            string = d < 0.01 ? "very low" : (d < 0.1 ? "low" : "slightly low");
        } else if (d > 0.3) {
            double d2 = 0.94;
            string = d > d2 ? "very high" : (d > 0.4 ? "high" : "slightly high");
        }
        String string2 = "";
        if (mCMCOperator instanceof GibbsOperator) {
            string2 = "none (Gibbs operator)";
        } else if (mCMCOperator instanceof AdaptableMCMCOperator) {
            String string3 = ((AdaptableMCMCOperator)mCMCOperator).getPerformanceSuggestion();
            string2 = string + "\t" + string3;
        }
        return string2;
    }
}

