/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class IndependentNormalDistributionSampler
extends SimpleMCMCOperator {
    public static final String OPERATOR_NAME = "independentNormalDistributionSampler";
    private Variable<Double> variable = null;
    private NormalDistributionModel model = null;
    private boolean updateAllIndependently = true;
    private static final boolean TRY_COLT = true;
    private static RandomEngine randomEngine;
    private static Normal coltNormal;
    public static XMLObjectParser PARSER;

    public IndependentNormalDistributionSampler(Variable variable, NormalDistributionModel normalDistributionModel) {
        this(variable, normalDistributionModel, 1.0);
    }

    public IndependentNormalDistributionSampler(Variable variable, NormalDistributionModel normalDistributionModel, double d) {
        this(variable, normalDistributionModel, d, true);
    }

    public IndependentNormalDistributionSampler(Variable variable, NormalDistributionModel normalDistributionModel, double d, boolean bl) {
        this.variable = variable;
        this.model = normalDistributionModel;
        this.updateAllIndependently = bl;
        this.setWeight(d);
        randomEngine = new MersenneTwister(MathUtils.nextInt());
        coltNormal = new Normal(0.0, 1.0, randomEngine);
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "independentNormalDistribution(" + this.variable.getVariableName() + ")";
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        Bounds<Double> bounds = this.variable.getBounds();
        int n = this.variable.getSize();
        if (this.updateAllIndependently) {
            for (int i = 0; i < n; ++i) {
                double d2 = this.variable.getValue(i);
                double d3 = coltNormal.nextDouble(this.model.getMean().getValue(i), 1.0 / Math.sqrt(this.model.getPrecision().getValue(i)));
                d += this.model.logPdf(d2) - this.model.logPdf(d3);
                if (d3 < bounds.getLowerLimit(i) || d3 > bounds.getUpperLimit(i)) {
                    return Double.NEGATIVE_INFINITY;
                }
                this.variable.setValue(i, d3);
            }
        }
        return d;
    }

    static {
        PARSER = new AbstractXMLObjectParser(){
            private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(NormalDistributionModel.class), new ElementRule(Parameter.class)};

            @Override
            public String getParserName() {
                return IndependentNormalDistributionSampler.OPERATOR_NAME;
            }

            @Override
            public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
                double d = xMLObject.getDoubleAttribute("weight");
                NormalDistributionModel normalDistributionModel = (NormalDistributionModel)xMLObject.getChild(NormalDistributionModel.class);
                Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
                return new IndependentNormalDistributionSampler(parameter, normalDistributionModel, d);
            }

            @Override
            public XMLSyntaxRule[] getSyntaxRules() {
                return this.rules;
            }

            @Override
            public String getParserDescription() {
                return "This element returns an independence sampler from a provided normal distribution model.";
            }

            @Override
            public Class getReturnType() {
                return MCMCOperator.class;
            }
        };
    }
}

