/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.OperatorUtils;
import dr.inference.operators.SimpleMCMCOperator;
import dr.util.NumberFormatter;

public abstract class AbstractAdaptableOperator
extends SimpleMCMCOperator
implements AdaptableMCMCOperator {
    public final AdaptationMode mode;
    private final double targetAcceptanceProbability;
    private long adaptationCount = 0L;

    public AbstractAdaptableOperator() {
        this(AdaptationMode.DEFAULT, 0.234);
    }

    public AbstractAdaptableOperator(AdaptationMode adaptationMode) {
        this(adaptationMode, 0.234);
    }

    public AbstractAdaptableOperator(AdaptationMode adaptationMode, double d) {
        this.mode = adaptationMode;
        this.targetAcceptanceProbability = System.getProperty("mcmc.adaptation_target") != null ? Double.parseDouble(System.getProperty("mcmc.adaptation_target")) : d;
    }

    @Override
    public final double getTargetAcceptanceProbability() {
        return this.targetAcceptanceProbability;
    }

    @Override
    public final long getAdaptationCount() {
        return this.adaptationCount;
    }

    @Override
    public final void setAdaptationCount(long l) {
        this.adaptationCount = l;
    }

    @Override
    public final void setAdaptableParameter(double d) {
        this.setAdaptableParameterValue(d);
        ++this.adaptationCount;
    }

    @Override
    public final double getAdaptableParameter() {
        return this.getAdaptableParameterValue();
    }

    protected abstract void setAdaptableParameterValue(double var1);

    protected abstract double getAdaptableParameterValue();

    @Override
    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    @Override
    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    @Override
    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    @Override
    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    @Override
    public String getPerformanceSuggestion() {
        return AbstractAdaptableOperator.getPerformanceSuggestion(this.getAcceptanceProbability(), this.getTargetAcceptanceProbability(), this.getRawParameter(), this.getAdaptableParameterName());
    }

    @Override
    public AdaptationMode getMode() {
        return this.mode;
    }

    public static String getPerformanceSuggestion(double d, double d2, double d3, String string) {
        NumberFormatter numberFormatter = new NumberFormatter(5);
        double d4 = OperatorUtils.optimizeWindowSize(d3, d, d2);
        if (d < 0.1) {
            return "Try setting " + string + " to about " + numberFormatter.format(d4);
        }
        if (d > 0.4) {
            return "Try setting " + string + " to about " + numberFormatter.format(d4);
        }
        return "";
    }
}

