/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import java.util.Stack;

public class RPNexpressionCalculator {
    Eelement[] expression;

    public RPNexpressionCalculator(String string) {
        String[] stringArray = string.trim().split("\\s+");
        this.expression = new Eelement[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Eelement eelement;
            String string2 = stringArray[i];
            if (string2.equals("+")) {
                eelement = new Eelement(OP.OP_ADD);
            } else if (string2.equals("-")) {
                eelement = new Eelement(OP.OP_SUB);
            } else if (string2.equals("*")) {
                eelement = new Eelement(OP.OP_MULT);
            } else if (string2.equals("/")) {
                eelement = new Eelement(OP.OP_DIV);
            } else if (string2.equals("log")) {
                eelement = new Eelement(OP.OP_LOG);
            } else if (string2.equals("exp")) {
                eelement = new Eelement(OP.OP_EXP);
            } else if (string2.equals("chs")) {
                eelement = new Eelement(OP.OP_CHS);
            } else {
                try {
                    double d = Double.parseDouble(string2);
                    eelement = new Eelement(d);
                }
                catch (NumberFormatException numberFormatException) {
                    eelement = new Eelement(string2);
                }
            }
            this.expression[i] = eelement;
        }
    }

    public double evaluate(GetVariable getVariable) {
        Stack<Double> stack = new Stack<Double>();
        block11: for (Eelement eelement : this.expression) {
            switch (eelement.op) {
                case OP_ADD: {
                    Double d = (Double)stack.pop();
                    Double d2 = (Double)stack.pop();
                    stack.push(d2 + d);
                    continue block11;
                }
                case OP_SUB: {
                    Double d = (Double)stack.pop();
                    Double d2 = (Double)stack.pop();
                    stack.push(d2 - d);
                    continue block11;
                }
                case OP_MULT: {
                    Double d = (Double)stack.pop();
                    Double d2 = (Double)stack.pop();
                    stack.push(d2 * d);
                    continue block11;
                }
                case OP_DIV: {
                    Double d = (Double)stack.pop();
                    Double d2 = (Double)stack.pop();
                    stack.push(d2 / d);
                    continue block11;
                }
                case OP_CHS: {
                    Double d = (Double)stack.pop();
                    stack.push(-d.doubleValue());
                    continue block11;
                }
                case OP_LOG: {
                    Double d = (Double)stack.pop();
                    if (d <= 0.0) {
                        return Double.NaN;
                    }
                    stack.push(Math.log(d));
                    continue block11;
                }
                case OP_EXP: {
                    Double d = (Double)stack.pop();
                    stack.push(Math.exp(d));
                    continue block11;
                }
                case OP_CONST: {
                    stack.push(eelement.value);
                    continue block11;
                }
                case OP_REF: {
                    stack.push(getVariable.get(eelement.name));
                }
            }
        }
        return (Double)stack.pop();
    }

    public String validate() {
        int n = 0;
        block6: for (Eelement eelement : this.expression) {
            switch (eelement.op) {
                case OP_ADD: 
                case OP_SUB: 
                case OP_MULT: 
                case OP_DIV: {
                    if (n < 2) {
                        return "Binary operator underflow";
                    }
                    --n;
                    continue block6;
                }
                case OP_CHS: 
                case OP_LOG: 
                case OP_EXP: {
                    if (n != 0) continue block6;
                    return "Unary operator underflow";
                }
                case OP_CONST: {
                    ++n;
                    continue block6;
                }
                case OP_REF: {
                    ++n;
                }
            }
        }
        if (n != 1) {
            return "Stack size " + n + " ( != 1 ) at end of expression evaluation";
        }
        return null;
    }

    private class Eelement {
        OP op;
        String name;
        private double value;

        Eelement(OP oP) {
            this.op = oP;
            this.name = null;
        }

        Eelement(String string) {
            this.op = OP.OP_REF;
            this.name = string;
        }

        Eelement(double d) {
            this.op = OP.OP_CONST;
            this.value = d;
        }
    }

    private static enum OP {
        OP_ADD,
        OP_SUB,
        OP_MULT,
        OP_DIV,
        OP_LOG,
        OP_EXP,
        OP_CHS,
        OP_CONST,
        OP_REF;

    }

    public static interface GetVariable {
        public double get(String var1);
    }
}

