/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.FastMatrixParameter;
import dr.inference.model.IntersectionBounds;
import dr.inference.model.Parameter;

public class FastBlockUpperTriangularMatrixParameter
extends FastMatrixParameter {
    private int rowDim;
    private Bounds bounds = null;

    public FastBlockUpperTriangularMatrixParameter(String string, int n, int n2) {
        super(string, n2, n, 1.0);
        boolean bl = false;
        if (bl) {
            for (int i = 0; i < this.getColumnDimension(); ++i) {
                if (i >= this.getRowDimension()) continue;
                double[] dArray = new double[i + 1];
                double[] dArray2 = new double[i + 1];
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[j] = Double.POSITIVE_INFINITY;
                    dArray2[j] = Double.NEGATIVE_INFINITY;
                }
                dArray2[i] = 0.0;
                this.getParameter(i).addBounds(new Parameter.DefaultBounds(dArray, dArray2));
            }
        }
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (!this.matrixCondition(n, n2)) {
            return 0.0;
        }
        return super.getParameterValue(n, n2);
    }

    protected int getRow(int n) {
        return n % this.getRowDimension();
    }

    protected int getColumn(int n) {
        return n / this.getRowDimension();
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        if (this.matrixCondition(n, n2)) {
            super.setParameterValueQuietly(n, n2, d);
        }
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        if (this.matrixCondition(n, n2)) {
            super.setParameterValue(n, n2, d);
        }
    }

    @Override
    public void setParameterValue(int n, double d) {
        int n2;
        int n3 = this.getRow(n);
        if (this.matrixCondition(n3, n2 = this.getColumn(n))) {
            this.setParameterValue(n3, n2, d);
        }
    }

    boolean matrixCondition(int n, int n2) {
        return n >= this.getColumnDimension() - n;
    }

    @Override
    public double getParameterValue(int n) {
        int n2;
        int n3 = this.getRow(n);
        if (this.matrixCondition(n3, n2 = this.getColumn(n))) {
            return this.getParameterValue(n3, n2);
        }
        return 0.0;
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        if (this.bounds == null) {
            this.bounds = new BUTMPBounds();
        }
        IntersectionBounds intersectionBounds = new IntersectionBounds(this.getDimension());
        intersectionBounds.addBounds(this.bounds);
        ((IntersectionBounds)this.bounds).addBounds(bounds);
    }

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            this.bounds = new BUTMPBounds();
        }
        return this.bounds;
    }

    protected int getInnerDimension(int n, int n2) {
        return n;
    }

    @Override
    public int getDimension() {
        return this.getRowDimension() * this.getColumnDimension();
    }

    private class BUTMPBounds
    implements Bounds<Double> {
        private BUTMPBounds() {
        }

        @Override
        public Double getUpperLimit(int n) {
            int n2;
            int n3 = FastBlockUpperTriangularMatrixParameter.this.getRow(n);
            if (FastBlockUpperTriangularMatrixParameter.this.matrixCondition(n3, n2 = FastBlockUpperTriangularMatrixParameter.this.getColumn(n))) {
                return FastBlockUpperTriangularMatrixParameter.this.getParameter(n2).getBounds().getUpperLimit(FastBlockUpperTriangularMatrixParameter.this.getInnerDimension(n3, n2));
            }
            return 0.0;
        }

        @Override
        public Double getLowerLimit(int n) {
            int n2;
            int n3 = FastBlockUpperTriangularMatrixParameter.this.getRow(n);
            if (FastBlockUpperTriangularMatrixParameter.this.matrixCondition(n3, n2 = FastBlockUpperTriangularMatrixParameter.this.getColumn(n))) {
                return FastBlockUpperTriangularMatrixParameter.this.getParameter(n2).getBounds().getLowerLimit(FastBlockUpperTriangularMatrixParameter.this.getInnerDimension(n3, n2));
            }
            return 0.0;
        }

        @Override
        public int getBoundsDimension() {
            return FastBlockUpperTriangularMatrixParameter.this.getDimension();
        }
    }
}

