/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class DiagonalConstrainedMatrixView
extends CompoundParameter
implements MatrixParameterInterface {
    private final MatrixParameterInterface matrix;
    private final Parameter mask;
    private final double constraintValue;
    private final double sqrtConstraintValue;

    public DiagonalConstrainedMatrixView(String string, MatrixParameterInterface matrixParameterInterface, Parameter parameter, double d) {
        super(string);
        this.matrix = matrixParameterInterface;
        this.mask = parameter;
        this.constraintValue = d;
        this.sqrtConstraintValue = Math.sqrt(d);
        matrixParameterInterface.addVariableListener(this);
    }

    private boolean constrained(int n) {
        return this.mask.getParameterValue(n) == 1.0;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (n == n2 && this.constrained(n)) {
            return this.constraintValue;
        }
        double d = this.matrix.getParameterValue(n, n2);
        if (this.constrained(n)) {
            d /= Math.sqrt(this.matrix.getParameterValue(n, n));
            d *= this.sqrtConstraintValue;
        }
        if (this.constrained(n2)) {
            d /= Math.sqrt(this.matrix.getParameterValue(n2, n2));
            d *= this.sqrtConstraintValue;
        }
        return d;
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public double[] getColumnValues(int n) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public double[][] getParameterAsMatrix() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.getParameterValue(i, j);
            }
        }
        return dArray;
    }

    @Override
    public int getDimension() {
        return this.matrix.getDimension();
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = n / this.getRowDimension();
        int n3 = n % this.getRowDimension();
        return this.getParameterValue(n2, n3);
    }

    @Override
    public String getDimensionName(int n) {
        return this.matrix.getDimensionName(n);
    }

    @Override
    public int getColumnDimension() {
        return this.matrix.getColumnDimension();
    }

    @Override
    public int getRowDimension() {
        return this.matrix.getRowDimension();
    }

    @Override
    public int getUniqueParameterCount() {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public String toSymmetricString() {
        return MatrixParameter.toSymmetricString(this);
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.matrix) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.fireParameterChangedEvent(n, changeType);
    }
}

