/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import cern.colt.bitvector.BitVector;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.Parameter;
import dr.math.MathUtils;

public interface BayesianStochasticSearchVariableSelection {
    public Parameter getIndicators();

    public boolean validState();

    public static class Utils {
        private static double defaultExpectedMutations = 1.0;
        private static double tolerance = 1.0E-20;

        public static boolean connectedAndWellConditioned(double[] dArray, SubstitutionModel substitutionModel) {
            if (dArray == null) {
                int n = substitutionModel.getDataType().getStateCount();
                dArray = new double[n * n];
            }
            try {
                substitutionModel.getTransitionProbabilities(defaultExpectedMutations, dArray);
                return Utils.connectedAndWellConditioned(dArray);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public static boolean connectedAndWellConditioned(double[] dArray, dr.oldevomodel.substmodel.SubstitutionModel substitutionModel) {
            if (dArray == null) {
                int n = substitutionModel.getDataType().getStateCount();
                dArray = new double[n * n];
            }
            try {
                substitutionModel.getTransitionProbabilities(defaultExpectedMutations, dArray);
                return Utils.connectedAndWellConditioned(dArray);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public static boolean connectedAndWellConditioned(double[] dArray) {
            for (double d : dArray) {
                if (!(d < tolerance) && !(d >= 1.0)) continue;
                return false;
            }
            return true;
        }

        public static void randomize(Parameter parameter, int n, boolean bl) {
            do {
                for (int i = 0; i < parameter.getDimension(); ++i) {
                    parameter.setParameterValue(i, MathUtils.nextDouble() < 0.5 ? 0.0 : 1.0);
                }
            } while (!Utils.isStronglyConnected(parameter.getParameterValues(), n, bl));
        }

        public static void setTolerance(double d) {
            tolerance = d;
        }

        public static double getTolerance() {
            return tolerance;
        }

        public static void setScalar(double d) {
            defaultExpectedMutations = d;
        }

        public static double getScalar() {
            return defaultExpectedMutations;
        }

        public static boolean isStronglyConnected(double[] dArray, int n, boolean bl) {
            BitVector bitVector = new BitVector(n);
            boolean bl2 = true;
            for (int i = 0; i < n && bl2; ++i) {
                bitVector.clear();
                Utils.depthFirstSearch(i, bitVector, dArray, n, bl);
                bl2 = bitVector.cardinality() == n;
            }
            return bl2;
        }

        private static boolean hasEdge(int n, int n2, double[] dArray, int n3, boolean bl) {
            return n != n2 && dArray[Utils.getEntry(n, n2, n3, bl)] == 1.0;
        }

        private static int getEntry(int n, int n2, int n3, boolean bl) {
            if (bl) {
                if (n2 < n) {
                    return Utils.getEntry(n2, n, n3, bl);
                }
                int n4 = n * n3 - n * (n + 1) / 2 + n2 - 1 - n;
                return n4;
            }
            int n5 = n * (n3 - 1) + n2;
            if (n2 > n) {
                --n5;
            }
            return n5;
        }

        private static void depthFirstSearch(int n, BitVector bitVector, double[] dArray, int n2, boolean bl) {
            bitVector.set(n);
            for (int i = 0; i < n2; ++i) {
                if (!Utils.hasEdge(n, i, dArray, n2, bl) || bitVector.get(i)) continue;
                Utils.depthFirstSearch(i, bitVector, dArray, n2, bl);
            }
        }
    }
}

