/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.ml;

import dr.inference.loggers.Logger;
import dr.inference.markovchain.MarkovChain;
import dr.inference.markovchain.MarkovChainListener;
import dr.inference.ml.GreatDelugeCriterion;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.operators.OperatorSchedule;
import dr.util.Identifiable;
import dr.util.Timer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MLOptimizer
implements Runnable,
Identifiable {
    private final Likelihood likelihood;
    private OperatorSchedule schedule;
    private final Logger[] loggers;
    int chainLength;
    private String id = null;
    private final MarkovChainListener chainListener = new MarkovChainListener(){

        @Override
        public void bestState(long l, MarkovChain markovChain, Model model) {
            MLOptimizer.this.currentState = l;
        }

        @Override
        public void currentState(long l, MarkovChain markovChain, Model model) {
            MLOptimizer.this.currentState = l;
            if (MLOptimizer.this.loggers != null) {
                for (Logger logger : MLOptimizer.this.loggers) {
                    logger.log(l);
                }
            }
        }

        @Override
        public void finished(long l, MarkovChain markovChain) {
            MLOptimizer.this.currentState = l;
            if (MLOptimizer.this.loggers != null) {
                for (Logger logger : MLOptimizer.this.loggers) {
                    logger.log(MLOptimizer.this.currentState);
                    logger.stopLogging();
                }
            }
        }

        public void bestLklModel(long l, Model model) {
            MLOptimizer.this.currentState = l;
        }
    };
    private long currentState;
    private final Timer timer = new Timer();
    private MarkovChain mc = null;

    public MLOptimizer(String string, int n, Likelihood likelihood, OperatorSchedule operatorSchedule, Logger[] loggerArray) {
        this.id = string;
        this.mc = new MarkovChain(likelihood, operatorSchedule, new GreatDelugeCriterion(0.2), 2000L, 1, 0.1, false, false);
        this.chainLength = n;
        this.likelihood = likelihood;
        this.loggers = loggerArray;
        this.setOperatorSchedule(operatorSchedule);
        this.currentState = 0L;
    }

    @Override
    public void run() {
        this.chain();
    }

    public void chain() {
        this.currentState = 0L;
        if (this.loggers != null) {
            for (Logger logger : this.loggers) {
                logger.startLogging();
            }
        }
        this.timer.start();
        this.mc.reset();
        this.timer.start();
        this.mc.addMarkovChainListener(this.chainListener);
        this.mc.runChain(this.getChainLength(), true);
        this.mc.removeMarkovChainListener(this.chainListener);
        this.timer.stop();
    }

    public Likelihood getLikelihood() {
        return this.likelihood;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setOperatorSchedule(OperatorSchedule operatorSchedule) {
        this.schedule = operatorSchedule;
    }

    public OperatorSchedule getOperatorSchedule() {
        return this.schedule;
    }

    public final int getChainLength() {
        return this.chainLength;
    }

    public final long getCurrentState() {
        return this.currentState;
    }

    public final double getProgress() {
        return (double)this.currentState / (double)this.chainLength;
    }

    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

