/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.math;

import dr.evolution.continuous.Contrastable;
import dr.geo.math.Vector3D;

public class SphericalPolarCoordinates
implements Contrastable {
    private double theta = 0.0;
    private double phi = 0.0;
    private double radius = 1.0;
    private static double VOLUMETRIC_RADIUS_OF_EARTH = 6371.0;

    public SphericalPolarCoordinates(Vector3D vector3D) {
        this(vector3D, vector3D.modulus());
    }

    public SphericalPolarCoordinates(Vector3D vector3D, double d) {
        this.radius = vector3D.modulus();
        this.theta = Math.acos(vector3D.getZ() / this.radius);
        this.phi = Math.atan(vector3D.getY() / vector3D.getX());
        if (vector3D.getY() < 0.0) {
            this.phi += Math.PI;
        }
        this.radius = d;
    }

    public SphericalPolarCoordinates(double d, double d2) {
        this(d, d2, VOLUMETRIC_RADIUS_OF_EARTH);
    }

    public SphericalPolarCoordinates(double d, double d2, double d3) {
        this.radius = d3;
        this.theta = (90.0 - d) * Math.PI / 180.0;
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        this.phi = d2 * Math.PI / 180.0;
    }

    public Vector3D getCartesianCoordinates() {
        double d = this.radius * Math.sin(this.theta) * Math.cos(this.phi);
        double d2 = this.radius * Math.sin(this.theta) * Math.sin(this.phi);
        double d3 = this.radius * Math.cos(this.theta);
        return new Vector3D(d, d2, d3);
    }

    public double getLatitude() {
        return 90.0 - this.theta * 180.0 / Math.PI;
    }

    public double getLongitude() {
        double d = this.phi * 180.0 / Math.PI;
        if (d > 180.0) {
            d -= 360.0;
        }
        return d;
    }

    public double angle(SphericalPolarCoordinates sphericalPolarCoordinates) {
        Vector3D vector3D = this.getCartesianCoordinates().normalized();
        Vector3D vector3D2 = sphericalPolarCoordinates.getCartesianCoordinates().normalized();
        double d = vector3D.cross(vector3D2).modulus();
        double d2 = vector3D.dot(vector3D2);
        double d3 = Math.atan2(d, d2);
        return d3;
    }

    public double distance(SphericalPolarCoordinates sphericalPolarCoordinates) {
        return this.angle(sphericalPolarCoordinates) * this.radius;
    }

    public static SphericalPolarCoordinates getMidpoint(SphericalPolarCoordinates sphericalPolarCoordinates, SphericalPolarCoordinates sphericalPolarCoordinates2) {
        return SphericalPolarCoordinates.interpolate(sphericalPolarCoordinates, sphericalPolarCoordinates2, 0.5);
    }

    public static SphericalPolarCoordinates interpolate(SphericalPolarCoordinates sphericalPolarCoordinates, SphericalPolarCoordinates sphericalPolarCoordinates2, double d) {
        double d2;
        double d3;
        Vector3D vector3D;
        Vector3D vector3D2 = sphericalPolarCoordinates.getCartesianCoordinates().normalized();
        double d4 = vector3D2.dot(vector3D = sphericalPolarCoordinates2.getCartesianCoordinates().normalized());
        if (d4 < 0.0) {
            d4 = -d4;
            vector3D.negate();
            System.out.println("Argg");
        }
        if (d4 > 0.999995) {
            d3 = d;
            d2 = 1.0 - d;
        } else {
            double d5 = Math.acos(d4);
            d3 = Math.sin(d * d5);
            d2 = Math.sin((1.0 - d) * d5);
        }
        Vector3D vector3D3 = vector3D2.mul(d3).add(vector3D.mul(d2)).normalized();
        return new SphericalPolarCoordinates(vector3D3, sphericalPolarCoordinates.getRadius());
    }

    public double getRadius() {
        return this.radius;
    }

    public String toString() {
        return this.toLatLongString();
    }

    public String toLatLongString() {
        double d = this.getLatitude();
        double d2 = this.getLongitude();
        String string = " N";
        if (d < 0.0) {
            d = -d;
            string = " S";
        }
        String string2 = " E";
        if (d2 < 0.0) {
            d2 = -d2;
            string2 = " W";
        }
        return d + string + ", " + d2 + string2;
    }

    public static void main(String[] stringArray) {
        double d = 66.0;
        double d2 = -174.0;
        double d3 = 64.0;
        double d4 = -142.0;
        SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(d, d2);
        SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(d3, d4);
        SphericalPolarCoordinates sphericalPolarCoordinates3 = new SphericalPolarCoordinates(sphericalPolarCoordinates.getCartesianCoordinates());
        SphericalPolarCoordinates sphericalPolarCoordinates4 = new SphericalPolarCoordinates(sphericalPolarCoordinates2.getCartesianCoordinates());
        System.out.println("point1=" + sphericalPolarCoordinates.toLatLongString());
        System.out.println("point2=" + sphericalPolarCoordinates2.toLatLongString());
        System.out.println("point1_test=" + sphericalPolarCoordinates3.toLatLongString());
        System.out.println("point2_test=" + sphericalPolarCoordinates4.toLatLongString());
        System.out.println("distance=" + sphericalPolarCoordinates.distance(sphericalPolarCoordinates2) + " kilometres");
        System.out.println("midpoint=" + SphericalPolarCoordinates.getMidpoint(sphericalPolarCoordinates, sphericalPolarCoordinates2).toLatLongString());
    }

    @Override
    public double getDifference(Contrastable contrastable) {
        if (contrastable instanceof SphericalPolarCoordinates) {
            return this.distance((SphericalPolarCoordinates)contrastable);
        }
        throw new IllegalArgumentException("Expected a spherical polar coordinate");
    }

    @Override
    public Contrastable getWeightedMean(double d, Contrastable contrastable, double d2, Contrastable contrastable2) {
        double d3 = d / (d + d2);
        if (contrastable instanceof SphericalPolarCoordinates && contrastable2 instanceof SphericalPolarCoordinates) {
            return SphericalPolarCoordinates.interpolate((SphericalPolarCoordinates)contrastable, (SphericalPolarCoordinates)contrastable2, d3);
        }
        throw new IllegalArgumentException("Expected a spherical polar coordinate");
    }
}

