/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.util.Identifiable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ContentRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class GeneralDataTypeParser
extends AbstractXMLObjectParser {
    public static final String GENERAL_DATA_TYPE = "generalDataType";
    public static final String STATE = "state";
    public static final String STATES = "states";
    public static final String ALIAS = "alias";
    public static final String AMBIGUITY = "ambiguity";
    public static final String CODE = "code";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Identifiable.class, 0, Integer.MAX_VALUE), new ContentRule("<state code=\"X\"/>"), new ContentRule("<alias code=\"Y\" state=\"X\"/>"), new ContentRule("<ambiguity code=\"Z\" states=\"XY\"/>")};

    @Override
    public String getParserName() {
        return GENERAL_DATA_TYPE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            if (xMLObject.getChild(i) instanceof XMLObject) {
                XMLObject xMLObject2 = (XMLObject)xMLObject.getChild(i);
                if (xMLObject2.getName().equals(STATE)) {
                    arrayList.add(xMLObject2.getStringAttribute(CODE));
                    continue;
                }
                if (xMLObject2.getName().equals(ALIAS) || xMLObject2.getName().equals(AMBIGUITY)) continue;
                throw new XMLParseException("illegal element, " + xMLObject2.getName() + ", in " + this.getParserName() + " element");
            }
            if (xMLObject.getChild(i) instanceof Identifiable) {
                arrayList.add(((Identifiable)xMLObject.getChild(i)).getId());
                continue;
            }
            throw new XMLParseException("illegal element in " + this.getParserName() + " element");
        }
        if (arrayList.size() == 0) {
            throw new XMLParseException("No state elements defined in " + this.getParserName() + " element");
        }
        if (arrayList.size() < 2) {
            throw new XMLParseException("Less than two state elements defined in " + this.getParserName() + " element");
        }
        GeneralDataType generalDataType = new GeneralDataType(arrayList);
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            String[] stringArray;
            String string;
            if (!(xMLObject.getChild(i) instanceof XMLObject)) continue;
            XMLObject xMLObject3 = (XMLObject)xMLObject.getChild(i);
            if (xMLObject3.getName().equals(ALIAS)) {
                string = xMLObject3.getStringAttribute(CODE);
                stringArray = xMLObject3.getStringAttribute(STATE);
                try {
                    generalDataType.addAlias(string, (String)stringArray);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XMLParseException(illegalArgumentException.getMessage() + "in " + this.getParserName() + " element");
                }
            }
            if (!xMLObject3.getName().equals(AMBIGUITY)) continue;
            string = xMLObject3.getStringAttribute(CODE);
            stringArray = xMLObject3.getStringArrayAttribute(STATES);
            if (stringArray.length == 1) {
                String string2 = stringArray[0];
                if (string2.length() < 2) {
                    throw new XMLParseException("States for ambiguity code in " + this.getParserName() + " element are not ambiguous");
                }
                stringArray = new String[string2.length()];
                for (int j = 0; j < string2.length(); ++j) {
                    stringArray[j] = String.valueOf(string2.charAt(j));
                }
            }
            try {
                generalDataType.addAmbiguity(string, stringArray);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XMLParseException(illegalArgumentException.getMessage() + "in " + this.getParserName() + " element");
            }
        }
        return generalDataType;
    }

    @Override
    public String getParserDescription() {
        return "Defines a general DataType for any number of states";
    }

    @Override
    public String getExample() {
        return "<!-- The XML for a nucleotide data type under this scheme would be -->\n<generalDataType id=\"nucleotides\">\n\t<state code=\"A\"/>\n\t<state code=\"C\"/>\n\t<state code=\"G\"/>\n\t<state code=\"T\"/>\n\t<alias code=\"U\" state=\"T\"/>\n\t<ambiguity code=\"R\" states=\"AG\"/>\n\t<ambiguity code=\"Y\" states=\"CT\"/>\n\t<ambiguity code=\"?\" states=\"ACGT\"/>\n\t<ambiguity code=\"-\" states=\"ACGT\"/>\n</generalDataType>\n";
    }

    @Override
    public Class getReturnType() {
        return DataType.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

