/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SimpleSiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evoxml.util.DataTypeUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;

public class AttributePatternsParser
extends AbstractXMLObjectParser {
    public static final String ATTRIBUTE = "attribute";
    public static final String SECONDARY_ATTRIBUTE = "secondary";
    public static final String PATTERNS = "Patterns";
    public static final String ATTRIBUTE_PATTERNS = "attributePatterns";
    private static final String MULTIPLE = "patternCount";
    private static final String REGEX = "regex";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new StringAttributeRule("dataType", "The data type", DataType.getRegisteredDataTypeNames(), false), new ElementRule(DataType.class)), AttributeRule.newStringRule("attribute"), AttributeRule.newStringRule("secondary", true), AttributeRule.newIntegerRule("patternCount", true), AttributeRule.newStringRule("regex", true), new ElementRule(TaxonList.class, "The taxon set")};

    @Override
    public String getParserName() {
        return ATTRIBUTE_PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        String string = xMLObject.getStringAttribute(ATTRIBUTE);
        String string2 = xMLObject.getAttribute(SECONDARY_ATTRIBUTE, null);
        TaxonList taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
        DataType dataType = DataTypeUtils.getDataType(xMLObject);
        int n = xMLObject.getAttribute(MULTIPLE, 1);
        String string3 = xMLObject.getAttribute(REGEX, "\\w+");
        if (dataType == null) {
            throw new XMLParseException("dataType expected for attributePatterns element");
        }
        SimpleSiteList simpleSiteList = new SimpleSiteList(dataType, taxonList);
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[taxonList.getTaxonCount()];
            boolean bl = true;
            for (int j = 0; j < taxonList.getTaxonCount(); ++j) {
                Object object;
                Taxon taxon = taxonList.getTaxon(j);
                if (string2 == null || string2.isEmpty()) {
                    object = taxon.getAttribute(string);
                    if (n > 1) {
                        String[] stringArray = object.toString().split(string3);
                        object = stringArray[i];
                    }
                    if (object != null) {
                        int n2 = dataType.getState(object.toString());
                        if (n2 < 0) {
                            throw new XMLParseException("State for attribute, " + string + ", in taxon, " + taxon.getId() + ", is unknown: " + object.toString());
                        }
                        nArray[j] = n2;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                object = taxon.getAttribute(string);
                Object object2 = taxon.getAttribute(string2);
                if (object != null && object2 != null) {
                    String string4 = object.toString() + "-" + object2.toString();
                    int n3 = dataType.getState(string4);
                    if (n3 < 0) {
                        throw new XMLParseException("State for attributes, " + string + " & " + string2 + ", in taxon, " + taxon.getId() + ", is unknown: " + string4);
                    }
                    nArray[j] = n3;
                    continue;
                }
                bl = false;
            }
            if (!bl) {
                throw new XMLParseException("The attribute, " + string + " was not found in all taxa. Check the name of the attribute.");
            }
            simpleSiteList.addPattern(nArray);
        }
        if (xMLObject.hasAttribute("id")) {
            Logger.getLogger("dr.evoxml").info("Read attribute patterns, '" + xMLObject.getId() + "' for attribute, " + string);
        } else {
            Logger.getLogger("dr.evoxml").info("Read attribute patterns for attribute, " + string);
        }
        return simpleSiteList;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A site pattern defined by an attribute in a set of taxa.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

