/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import beagle.Beagle;
import beagle.BeagleFactory;
import beagle.BeagleFlag;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import dr.evolution.alignment.AscertainedSitePatterns;
import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.tipstatesmodel.TipStatesModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.BeagleFunctionality;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treelikelihood.AbstractTreeLikelihood;
import dr.evomodel.treelikelihood.PartialsRescalingScheme;
import dr.evomodel.treelikelihood.SubstitutionModelDelegate;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.ThreadAwareLikelihood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

@Deprecated
public class MultiPartitionTreeLikelihood
extends AbstractTreeLikelihood
implements ThreadAwareLikelihood {
    private static final String RESOURCE_ORDER_PROPERTY = "beagle.resource.order";
    private static final String PREFERRED_FLAGS_PROPERTY = "beagle.preferred.flags";
    private static final String REQUIRED_FLAGS_PROPERTY = "beagle.required.flags";
    private static final String SCALING_PROPERTY = "beagle.scaling";
    private static final String RESCALE_FREQUENCY_PROPERTY = "beagle.rescale";
    private static final String EXTRA_BUFFER_COUNT_PROPERTY = "beagle.extra.buffer.count";
    private static final String FORCE_VECTORIZATION = "beagle.force.vectorization";
    private static final PartialsRescalingScheme DEFAULT_RESCALING_SCHEME = PartialsRescalingScheme.DYNAMIC;
    private static int instanceCount = 0;
    private static List<Integer> resourceOrder = null;
    private static List<Integer> preferredOrder = null;
    private static List<Integer> requiredOrder = null;
    private static List<String> scalingOrder = null;
    private static List<Integer> extraBufferOrder = null;
    private static final int RESCALE_FREQUENCY = 100;
    private static final int RESCALE_TIMES = 1;
    private int[] branchUpdateIndices;
    private double[] branchLengths;
    private int branchUpdateCount;
    private int[] scaleBufferIndices;
    private int[] storedScaleBufferIndices;
    private int[][] operations;
    private int operationListCount;
    private int[] operationCount;
    private static final boolean hasRestrictedPartials = false;
    private final int numRestrictedPartials;
    private final Map<Set<String>, Parameter> partialsRestrictions;
    private Parameter[] partialsMap;
    private double[] partials;
    private boolean updateRestrictedNodePartials;
    protected BufferIndexHelper partialBufferHelper;
    protected BufferIndexHelper scaleBufferHelper;
    protected final int tipCount;
    protected final int internalNodeCount;
    private PartialsRescalingScheme rescalingScheme;
    private int rescalingFrequency = 100;
    protected boolean useScaleFactors = false;
    private boolean useAutoScaling = false;
    private boolean recomputeScaleFactors = false;
    private boolean everUnderflowed = false;
    private int rescalingCount = 0;
    private int rescalingCountInner = 0;
    private final BranchModel branchModel;
    private final SubstitutionModelDelegate[] substitutionModelDelegates;
    private final List<PatternList> patternLists = new ArrayList<PatternList>();
    private final List<SiteRateModel> siteRateModels = new ArrayList<SiteRateModel>();
    private final BranchRateModel branchRateModel;
    private final TipStatesModel tipStatesModel;
    private final int patternCount;
    private final int partitionCount;
    private final int[] patternCounts;
    private final double[] patternLogLikelihoods;
    private final int categoryCount;
    private final Beagle beagle;
    protected final boolean[] updateSubstitutionModel;
    private final boolean[] updateSiteModel;
    private final DataType dataType;
    private final double[] patternWeights;
    private final int stateCount;
    protected final boolean useAmbiguities;

    public MultiPartitionTreeLikelihood(List<PatternList> list, List<SiteRateModel> list2, TreeModel treeModel, BranchModel branchModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, PartialsRescalingScheme partialsRescalingScheme) {
        this(list, list2, treeModel, branchModel, branchRateModel, tipStatesModel, bl, partialsRescalingScheme, null);
    }

    /*
     * WARNING - void declaration
     */
    public MultiPartitionTreeLikelihood(List<PatternList> list, List<SiteRateModel> list2, TreeModel treeModel, BranchModel branchModel, BranchRateModel branchRateModel, TipStatesModel tipStatesModel, boolean bl, PartialsRescalingScheme partialsRescalingScheme, Map<Set<String>, Parameter> map) {
        super("treeLikelihood", treeModel);
        try {
            void var28_45;
            int n;
            int n2;
            String string;
            int n3;
            Logger logger = Logger.getLogger("dr.evomodel");
            logger.info("Using BEAGLE TreeLikelihood");
            assert (list.size() == list2.size());
            this.dataType = list.get(0).getDataType();
            this.stateCount = this.dataType.getStateCount();
            this.partitionCount = list.size();
            this.patternLists.addAll(list);
            for (PatternList identifiable : list) {
                assert (identifiable.getDataType() == this.dataType);
            }
            this.siteRateModels.addAll(list2);
            this.categoryCount = this.siteRateModels.get(0).getCategoryCount();
            for (SiteRateModel siteRateModel : list2) {
                assert (siteRateModel.getCategoryCount() == this.categoryCount);
                this.addModel(siteRateModel);
            }
            this.branchModel = branchModel;
            this.addModel(this.branchModel);
            if (branchRateModel != null) {
                this.branchRateModel = branchRateModel;
                logger.info("  Branch rate model used: " + branchRateModel.getModelName());
            } else {
                this.branchRateModel = new DefaultBranchRateModel();
            }
            this.addModel(this.branchRateModel);
            this.tipStatesModel = tipStatesModel;
            this.tipCount = treeModel.getExternalNodeCount();
            this.internalNodeCount = this.nodeCount - this.tipCount;
            int n32 = this.tipCount;
            if (bl) {
                n32 = 0;
            }
            this.partialBufferHelper = new BufferIndexHelper(this.nodeCount, this.tipCount);
            this.scaleBufferHelper = new BufferIndexHelper(this.getScaleBufferCount(), 0);
            if (resourceOrder == null) {
                resourceOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(RESOURCE_ORDER_PROPERTY);
            }
            if (preferredOrder == null) {
                preferredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(PREFERRED_FLAGS_PROPERTY);
            }
            if (requiredOrder == null) {
                requiredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(REQUIRED_FLAGS_PROPERTY);
            }
            if (scalingOrder == null) {
                scalingOrder = BeagleFunctionality.parseSystemPropertyStringArray(SCALING_PROPERTY);
            }
            if (extraBufferOrder == null) {
                extraBufferOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(EXTRA_BUFFER_COUNT_PROPERTY);
            }
            int n4 = -1;
            if (extraBufferOrder.size() > 0) {
                n3 = extraBufferOrder.get(instanceCount % extraBufferOrder.size());
            }
            this.substitutionModelDelegates = new SubstitutionModelDelegate[this.partitionCount];
            for (int i = 0; i < this.partitionCount; ++i) {
                this.substitutionModelDelegates[i] = new SubstitutionModelDelegate(treeModel, branchModel, n3);
            }
            this.rescalingScheme = partialsRescalingScheme;
            int[] nArray = null;
            long l = 0L;
            long l2 = 0L;
            if (scalingOrder.size() > 0) {
                this.rescalingScheme = PartialsRescalingScheme.parseFromString(scalingOrder.get(instanceCount % scalingOrder.size()));
            }
            if (resourceOrder.size() > 0 && (nArray = new int[]{resourceOrder.get(instanceCount % resourceOrder.size()), 0})[0] > 0) {
                l |= BeagleFlag.PROCESSOR_GPU.getMask();
            }
            if (preferredOrder.size() > 0) {
                l = preferredOrder.get(instanceCount % preferredOrder.size()).intValue();
            }
            if (requiredOrder.size() > 0) {
                l2 = requiredOrder.get(instanceCount % requiredOrder.size()).intValue();
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DEFAULT) {
                this.rescalingScheme = nArray != null && nArray[0] > true ? DEFAULT_RESCALING_SCHEME : DEFAULT_RESCALING_SCHEME;
            }
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO) {
                l |= BeagleFlag.SCALING_AUTO.getMask();
                this.useAutoScaling = true;
            }
            if ((string = System.getProperty(RESCALE_FREQUENCY_PROPERTY)) != null) {
                this.rescalingFrequency = Integer.parseInt(string);
                if (this.rescalingFrequency < 1) {
                    this.rescalingFrequency = 100;
                }
            }
            this.patternCounts = new int[this.partitionCount];
            int n5 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.patternCounts[n2] = list.get(n2).getPatternCount();
                n5 += this.patternCounts[n2];
            }
            this.patternCount = n5;
            this.patternWeights = new double[this.patternCount];
            n2 = 0;
            for (PatternList patternList : list) {
                for (n = 0; n < patternList.getPatternCount(); ++n) {
                    this.patternWeights[n2] = patternList.getPatternWeight(n);
                    ++n2;
                }
            }
            if (l == 0L && nArray == null && this.stateCount == 4 && this.patternCount < 10000) {
                l |= BeagleFlag.PROCESSOR_CPU.getMask();
            }
            boolean bl2 = false;
            String string2 = System.getProperty(FORCE_VECTORIZATION);
            if (string2 != null) {
                bl2 = true;
            }
            if (BeagleFlag.VECTOR_SSE.isSet(l) && this.stateCount != 4 && !bl2) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
                l |= BeagleFlag.VECTOR_NONE.getMask();
                if (this.stateCount > 4 && this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                    this.rescalingScheme = PartialsRescalingScheme.DELAYED;
                }
            }
            if (!BeagleFlag.PRECISION_SINGLE.isSet(l)) {
                l |= BeagleFlag.PRECISION_DOUBLE.getMask();
            }
            if (this.substitutionModelDelegates[0].canReturnComplexDiagonalization()) {
                l2 |= BeagleFlag.EIGEN_COMPLEX.getMask();
            }
            n = 0;
            int n6 = 0;
            for (SubstitutionModelDelegate substitutionModelDelegate : this.substitutionModelDelegates) {
                n += substitutionModelDelegate.getEigenBufferCount();
                n6 += substitutionModelDelegate.getMatrixBufferCount();
            }
            if (nArray == null && (BeagleFlag.PROCESSOR_GPU.isSet(l) || BeagleFlag.FRAMEWORK_CUDA.isSet(l) || BeagleFlag.FRAMEWORK_OPENCL.isSet(l)) || nArray != null && nArray[0] > 0) {
                l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++instanceCount;
            this.beagle = BeagleFactory.loadBeagleInstance(this.tipCount, this.partialBufferHelper.getBufferCount(), n32, this.stateCount, this.patternCount, n, n6, this.categoryCount, this.scaleBufferHelper.getBufferCount(), nArray, l, l2);
            InstanceDetails instanceDetails = this.beagle.getDetails();
            ResourceDetails resourceDetails = null;
            if (instanceDetails != null) {
                resourceDetails = BeagleFactory.getResourceDetails(instanceDetails.getResourceNumber());
                if (resourceDetails != null) {
                    StringBuilder stringBuilder = new StringBuilder("  Using BEAGLE resource ");
                    stringBuilder.append(resourceDetails.getNumber()).append(": ");
                    stringBuilder.append(resourceDetails.getName()).append("\n");
                    if (resourceDetails.getDescription() != null) {
                        String[] stringArray = resourceDetails.getDescription().split("\\|");
                        for (String string3 : stringArray) {
                            if (string3.trim().length() <= 0) continue;
                            stringBuilder.append("    ").append(string3.trim()).append("\n");
                        }
                    }
                    stringBuilder.append("    with instance flags: ").append(instanceDetails.toString());
                    logger.info(stringBuilder.toString());
                } else {
                    logger.info("  Error retrieving BEAGLE resource for instance: " + instanceDetails.toString());
                }
            } else {
                logger.info("  No external BEAGLE resources available, or resource list/requirements not met, using Java implementation");
            }
            logger.info("  " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            if (list.size() > 1) {
                logger.info("  With " + this.patternCount + " unique site patterns in " + list.size() + " partitions.");
            } else {
                logger.info("  With " + this.patternCount + " unique site patterns.");
            }
            if (tipStatesModel != null) {
                throw new UnsupportedOperationException("Tip error models not supported by MultiPartitionTreeLikelihood yet");
            }
            for (int i = 0; i < this.tipCount; ++i) {
                String string4 = treeModel.getTaxonId(i);
                for (PatternList patternList : list) {
                    int n7 = patternList.getTaxonIndex(string4);
                    if (n7 == -1) {
                        throw new TaxonList.MissingTaxonException("Taxon, " + string4 + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                    }
                    if (tipStatesModel != null) {
                        throw new UnsupportedOperationException("Tip error models not supported by MultiPartitionTreeLikelihood yet");
                    }
                    if (bl) {
                        this.setPartials(this.beagle, n7, i);
                        continue;
                    }
                    this.setStates(this.beagle, n7, i);
                }
            }
            this.partialsRestrictions = map;
            this.numRestrictedPartials = 0;
            this.updateRestrictedNodePartials = false;
            this.beagle.setPatternWeights(this.patternWeights);
            String string5 = "  Using rescaling scheme : " + this.rescalingScheme.getText();
            if (this.rescalingScheme == PartialsRescalingScheme.AUTO && resourceDetails != null && (resourceDetails.getFlags() & BeagleFlag.SCALING_AUTO.getMask()) == 0L) {
                this.rescalingScheme = PartialsRescalingScheme.DYNAMIC;
                string5 = "  Auto rescaling not supported in BEAGLE, using : " + this.rescalingScheme.getText();
            }
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                string5 = string5 + " (rescaling every " + this.rescalingFrequency + " evaluations)";
            }
            logger.info(string5);
            if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
                this.everUnderflowed = false;
            }
            this.updateSubstitutionModel = new boolean[this.partitionCount];
            this.updateSiteModel = new boolean[this.partitionCount];
            boolean bl3 = false;
            while (var28_45 < this.partitionCount) {
                this.updateSubstitutionModel[var28_45] = true;
                this.updateSiteModel[var28_45] = true;
                ++var28_45;
            }
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
        this.useAmbiguities = bl;
        this.hasInitialized = true;
    }

    public TipStatesModel getTipStatesModel() {
        return this.tipStatesModel;
    }

    public Tree getTreeModel() {
        return this.treeModel;
    }

    public BranchModel getBranchModel() {
        return this.branchModel;
    }

    public BranchRateModel getBranchRateModel() {
        return this.branchRateModel;
    }

    public PartialsRescalingScheme getRescalingScheme() {
        return this.rescalingScheme;
    }

    public Map<Set<String>, Parameter> getPartialsRestrictions() {
        return this.partialsRestrictions;
    }

    public boolean useAmbiguities() {
        return this.useAmbiguities;
    }

    protected int getScaleBufferCount() {
        return this.internalNodeCount + 1;
    }

    protected final void setPartials(Beagle beagle, int n, int n2) {
        int n3;
        int n4;
        double[] dArray = new double[this.patternCount * this.stateCount * this.categoryCount];
        int n5 = 0;
        for (PatternList patternList : this.patternLists) {
            for (n4 = 0; n4 < patternList.getPatternCount(); ++n4) {
                int n6 = patternList.getPatternState(n, n4);
                boolean[] blArray = this.dataType.getStateSet(n6);
                for (int i = 0; i < this.stateCount; ++i) {
                    dArray[n5] = blArray[i] ? 1.0 : 0.0;
                    ++n5;
                }
            }
        }
        int n7 = n3 = this.patternCount * this.stateCount;
        for (n4 = 1; n4 < this.categoryCount; ++n4) {
            System.arraycopy(dArray, 0, dArray, n7, n3);
            n7 += n3;
        }
        beagle.setPartials(n2, dArray);
    }

    public int getPatternCount() {
        return this.patternCount;
    }

    private final void setStates(Beagle beagle, int n, int n2) {
        int[] nArray = new int[this.patternCount];
        int n3 = 0;
        for (PatternList patternList : this.patternLists) {
            for (int i = 0; i < patternList.getPatternCount(); ++i) {
                nArray[n3] = patternList.getPatternState(n, i);
                ++n3;
            }
        }
        beagle.setTipStates(n2, nArray);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                    this.updateRestrictedNodePartials = true;
                } else if (((TreeChangedEvent)object).isTreeChanged()) {
                    this.updateAllNodes();
                    this.updateRestrictedNodePartials = true;
                }
            }
        } else if (model == this.branchRateModel) {
            if (n == -1) {
                ++this.totalRateUpdateAllCount;
                this.updateAllNodes();
            } else {
                ++this.totalRateUpdateSingleCount;
                this.updateNode(this.treeModel.getNode(n));
            }
        } else if (model == this.branchModel) {
            this.makeDirty();
        } else if (this.siteRateModels.contains(model)) {
            this.updateSiteModel[this.siteRateModels.indexOf((Object)model)] = true;
            this.updateAllNodes();
        } else if (model == this.tipStatesModel) {
            if (object instanceof Taxon) {
                for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                    if (this.treeModel.getNodeTaxon(this.treeModel.getNode(i)) == null || !this.treeModel.getNodeTaxon(this.treeModel.getNode(i)).getId().equalsIgnoreCase(((Taxon)object).getId())) continue;
                    this.updateNode(this.treeModel.getNode(i));
                }
            } else {
                this.updateAllNodes();
            }
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    public void makeDirty() {
        super.makeDirty();
        for (int i = 0; i < this.partitionCount; ++i) {
            this.updateSubstitutionModel[i] = true;
            this.updateSiteModel[i] = true;
        }
        this.updateRestrictedNodePartials = true;
    }

    @Override
    protected void storeState() {
        this.partialBufferHelper.storeState();
        for (SubstitutionModelDelegate substitutionModelDelegate : this.substitutionModelDelegates) {
            substitutionModelDelegate.storeState();
        }
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.storeState();
            System.arraycopy(this.scaleBufferIndices, 0, this.storedScaleBufferIndices, 0, this.scaleBufferIndices.length);
        }
        super.storeState();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void restoreState() {
        void objectArray;
        boolean i = false;
        while (objectArray < this.partitionCount) {
            this.updateSiteModel[objectArray] = true;
            ++objectArray;
        }
        this.partialBufferHelper.restoreState();
        for (SubstitutionModelDelegate substitutionModelDelegate : this.substitutionModelDelegates) {
            substitutionModelDelegate.restoreState();
        }
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.restoreState();
            int[] nArray = this.storedScaleBufferIndices;
            this.storedScaleBufferIndices = this.scaleBufferIndices;
            this.scaleBufferIndices = nArray;
        }
        this.updateRestrictedNodePartials = true;
        super.restoreState();
    }

    @Override
    protected double calculateLogLikelihood() {
        double d;
        int n;
        int n2;
        int n3;
        if (this.branchUpdateIndices == null) {
            this.branchUpdateIndices = new int[this.nodeCount];
            this.branchLengths = new double[this.nodeCount];
            this.scaleBufferIndices = new int[this.internalNodeCount];
            this.storedScaleBufferIndices = new int[this.internalNodeCount];
        }
        if (this.operations == null) {
            this.operations = new int[this.numRestrictedPartials + 1][this.internalNodeCount * 7];
            this.operationCount = new int[this.numRestrictedPartials + 1];
        }
        this.recomputeScaleFactors = false;
        if (this.rescalingScheme == PartialsRescalingScheme.ALWAYS) {
            this.useScaleFactors = true;
            this.recomputeScaleFactors = true;
        } else if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC && this.everUnderflowed) {
            this.useScaleFactors = true;
            if (this.rescalingCountInner < 1) {
                this.recomputeScaleFactors = true;
                this.makeDirty();
            }
            ++this.rescalingCountInner;
            ++this.rescalingCount;
            if (this.rescalingCount > this.rescalingFrequency) {
                this.rescalingCount = 0;
                this.rescalingCountInner = 0;
            }
        } else if (this.rescalingScheme == PartialsRescalingScheme.DELAYED && this.everUnderflowed) {
            this.useScaleFactors = true;
            this.recomputeScaleFactors = true;
            ++this.rescalingCount;
        }
        if (this.tipStatesModel != null) {
            throw new UnsupportedOperationException("Tip error models not supported by MultiPartitionTreeLikelihood yet");
        }
        this.branchUpdateCount = 0;
        this.operationListCount = 0;
        this.operationCount[0] = 0;
        NodeRef nodeRef = this.treeModel.getRoot();
        this.traverse(this.treeModel, nodeRef, null, true);
        for (n3 = 0; n3 < this.partitionCount; ++n3) {
            if (this.updateSubstitutionModel[n3]) {
                this.substitutionModelDelegates[n3].updateSubstitutionModels(this.beagle);
            }
            if (!this.updateSiteModel[n3]) continue;
            double[] dArray = this.siteRateModels.get(n3).getCategoryRates();
            this.beagle.setCategoryRates(dArray);
        }
        if (this.branchUpdateCount > 0) {
            for (SubstitutionModelDelegate substitutionModelDelegate : this.substitutionModelDelegates) {
                substitutionModelDelegate.updateTransitionMatrices(this.beagle, this.branchUpdateIndices, this.branchLengths, this.branchUpdateCount);
            }
        }
        this.totalMatrixUpdateCount += this.branchUpdateCount;
        for (n3 = 0; n3 <= this.numRestrictedPartials; ++n3) {
            this.totalOperationCount += this.operationCount[n3];
        }
        boolean bl = true;
        do {
            this.beagle.updatePartials(this.operations[0], this.operationCount[0], -1);
            n = -1;
            if (this.useScaleFactors) {
                if (this.recomputeScaleFactors) {
                    this.scaleBufferHelper.flipOffset(this.internalNodeCount);
                    n = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                    this.beagle.resetScaleFactors(n);
                    this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, n);
                } else {
                    n = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                }
            } else if (this.useAutoScaling) {
                this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, -1);
            }
            for (int i = 0; i < this.partitionCount; ++i) {
                double[] dArray = this.siteRateModels.get(i).getCategoryProportions();
                double[] dArray2 = this.substitutionModelDelegates[i].getRootStateFrequencies();
                this.beagle.setCategoryWeights(i, dArray);
                this.beagle.setStateFrequencies(i, dArray2);
            }
            double[] dArray = new double[1];
            int n4 = this.partialBufferHelper.getOffsetIndex(nodeRef.getNumber());
            this.beagle.calculateRootLogLikelihoods(new int[]{n4}, new int[]{0}, new int[]{0}, new int[]{n}, 1, dArray);
            d = dArray[0];
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                this.everUnderflowed = true;
                d = Double.NEGATIVE_INFINITY;
                if (bl && (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC || this.rescalingScheme == PartialsRescalingScheme.DELAYED)) {
                    if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC || this.rescalingCount == 0) {
                        Logger.getLogger("dr.evomodel").info("Underflow calculating likelihood. Attempting a rescaling...");
                    }
                    this.useScaleFactors = true;
                    this.recomputeScaleFactors = true;
                    this.branchUpdateCount = 0;
                    this.operationCount[0] = 0;
                    this.traverse(this.treeModel, nodeRef, null, false);
                    n2 = 0;
                    bl = false;
                    continue;
                }
                n2 = 1;
                continue;
            }
            n2 = 1;
        } while (n2 == 0);
        for (n = 0; n < this.nodeCount; ++n) {
            this.updateNode[n] = false;
        }
        for (n = 0; n < this.partitionCount; ++n) {
            this.updateSubstitutionModel[n] = false;
            this.updateSiteModel[n] = false;
        }
        return d;
    }

    public void getPartials(int n, double[] dArray) {
        int n2 = -1;
        this.beagle.getPartials(this.partialBufferHelper.getOffsetIndex(n), n2, dArray);
    }

    public boolean arePartialsRescaled() {
        return this.useScaleFactors;
    }

    protected void setPartials(int n, double[] dArray) {
        this.beagle.setPartials(this.partialBufferHelper.getOffsetIndex(n), dArray);
    }

    private void restrictNodePartials(int n) {
        Parameter parameter = this.partialsMap[n];
        if (parameter == null) {
            return;
        }
        this.getPartials(n, this.partials);
        double[] dArray = parameter.getParameterValues();
        int n2 = this.stateCount * this.patternCount;
        if (dArray.length == n2) {
            for (int i = 0; i < this.categoryCount; ++i) {
                this.componentwiseMultiply(this.partials, n2 * i, dArray, 0, n2);
            }
        } else {
            this.componentwiseMultiply(this.partials, 0, dArray, 0, n2 * this.categoryCount);
        }
        this.setPartials(n, this.partials);
    }

    private void componentwiseMultiply(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = n + i;
            dArray[n4] = dArray[n4] * dArray2[n2 + i];
        }
    }

    private void computeNodeToRestrictionMap() {
        Arrays.fill(this.partialsMap, null);
        for (Set<String> set : this.partialsRestrictions.keySet()) {
            NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.treeModel, set);
            this.partialsMap[nodeRef.getNumber()] = this.partialsRestrictions.get(set);
        }
    }

    private double getAscertainmentCorrectedLogLikelihood(AscertainedSitePatterns ascertainedSitePatterns, double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = ascertainedSitePatterns.getAscertainmentCorrection(dArray);
        for (int i = 0; i < this.patternCount; ++i) {
            d += (dArray[i] - d2) * dArray2[i];
        }
        return d;
    }

    private boolean traverse(Tree tree, NodeRef nodeRef, int[] nArray, boolean bl) {
        boolean bl2 = false;
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nArray != null) {
            nArray[0] = -1;
        }
        if (nodeRef2 != null && this.updateNode[n]) {
            double d;
            double d2;
            double d3 = this.branchRateModel.getBranchRate(tree, nodeRef);
            double d4 = d3 * ((d2 = tree.getNodeHeight(nodeRef2)) - (d = tree.getNodeHeight(nodeRef)));
            if (d4 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d4);
            }
            if (bl) {
                for (SubstitutionModelDelegate substitutionModelDelegate : this.substitutionModelDelegates) {
                    substitutionModelDelegate.flipMatrixBuffer(n);
                }
            }
            this.branchUpdateIndices[this.branchUpdateCount] = n;
            this.branchLengths[this.branchUpdateCount] = d4;
            ++this.branchUpdateCount;
            bl2 = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            int[] nArray2 = new int[]{-1};
            boolean bl3 = this.traverse(tree, nodeRef3, nArray2, bl);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            int[] nArray3 = new int[]{-1};
            boolean bl4 = this.traverse(tree, nodeRef4, nArray3, bl);
            if (bl3 || bl4) {
                int n2 = this.operationCount[this.operationListCount] * 7;
                if (bl) {
                    this.partialBufferHelper.flipOffset(n);
                }
                int[] nArray4 = this.operations[this.operationListCount];
                nArray4[n2] = this.partialBufferHelper.getOffsetIndex(n);
                if (this.useScaleFactors) {
                    int n3 = n - this.tipCount;
                    if (this.recomputeScaleFactors) {
                        this.scaleBufferHelper.flipOffset(n3);
                        this.scaleBufferIndices[n3] = this.scaleBufferHelper.getOffsetIndex(n3);
                        nArray4[n2 + 1] = this.scaleBufferIndices[n3];
                        nArray4[n2 + 2] = -1;
                    } else {
                        nArray4[n2 + 1] = -1;
                        nArray4[n2 + 2] = this.scaleBufferIndices[n3];
                    }
                } else {
                    if (this.useAutoScaling) {
                        this.scaleBufferIndices[n - this.tipCount] = this.partialBufferHelper.getOffsetIndex(n);
                    }
                    nArray4[n2 + 1] = -1;
                    nArray4[n2 + 2] = -1;
                }
                nArray4[n2 + 3] = this.partialBufferHelper.getOffsetIndex(nodeRef3.getNumber());
                nArray4[n2 + 5] = this.partialBufferHelper.getOffsetIndex(nodeRef4.getNumber());
                int n4 = this.operationListCount;
                this.operationCount[n4] = this.operationCount[n4] + 1;
                bl2 = true;
            }
        }
        return bl2;
    }
}

