/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeTransform;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class ExtendTipBranchTransform
extends TreeTransform {
    private final Parameter diffusionPrecision;

    public ExtendTipBranchTransform(Parameter parameter) {
        super("extendTipBranchTransform");
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.diffusionPrecision = parameter;
        this.addVariable(parameter);
    }

    @Override
    public double transform(Tree tree, NodeRef nodeRef, double d) {
        double d2 = tree.getNodeHeight(tree.getRoot());
        if (tree.isExternal(nodeRef)) {
            return d;
        }
        return d + this.getExtensionForNode(tree, nodeRef) * d2;
    }

    @Override
    protected double getScaleForNode(Tree tree, NodeRef nodeRef) {
        return this.diffusionPrecision.getParameterValue(0);
    }

    private double getExtensionForNode(Tree tree, NodeRef nodeRef) {
        double d = 1.0 - 1.0 / this.getScaleForNode(tree, nodeRef);
        return d * this.getScaleForNode(tree, nodeRef);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged(this.diffusionPrecision);
    }

    @Override
    public String getInfo() {
        return null;
    }
}

