/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeModel;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.inference.loggers.MLLogger;
import dr.inference.loggers.TabDelimitedFormatter;
import dr.inferencexml.loggers.LoggerParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Deprecated
public class ConvergenceLogger
extends MCLogger {
    public static final String LOG_CONVERGENCE = "LogConvergence";
    public static final String TREE_FILE_NAME = "treeFilename";
    public static final String REFERENCE_FILE_NAME = "referenceFilename";
    public static final String CHECK_EVERY = "checkEvery";
    private Tree tree = null;
    private BufferedWriter bwDistances = null;
    private long trees = 0L;
    private HashMap<BitSet, Double> referenceCladeFrequencies = null;
    private HashMap<BitSet, Double> cladeOccurences = null;
    private String outputFilename;
    private HashMap<String, Integer> taxonMap;
    private String[] taxonArray;
    private String referenceTreeFileName;
    public static XMLObjectParser PARSER = new LoggerParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("treeFilename", "name of a tree log file", "trees.log"), new StringAttributeRule("referenceFilename", "name of a reference tree file", "trees.log"), AttributeRule.newIntegerRule("checkEvery", true), new ElementRule(TreeModel.class)};

        public String getParserName() {
            return ConvergenceLogger.LOG_CONVERGENCE;
        }

        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute(ConvergenceLogger.TREE_FILE_NAME);
            String string2 = xMLObject.getStringAttribute(ConvergenceLogger.REFERENCE_FILE_NAME);
            int n = 1;
            if (xMLObject.hasAttribute(ConvergenceLogger.CHECK_EVERY)) {
                n = xMLObject.getIntegerAttribute(ConvergenceLogger.CHECK_EVERY);
            }
            Tree tree = (Tree)xMLObject.getChild(Tree.class);
            PrintWriter printWriter = 1.getLogFile((XMLObject)xMLObject, (String)this.getParserName());
            TabDelimitedFormatter tabDelimitedFormatter = new TabDelimitedFormatter(printWriter);
            ConvergenceLogger convergenceLogger = new ConvergenceLogger(tree, tabDelimitedFormatter, n, string, string2);
            return convergenceLogger;
        }

        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        public String getParserDescription() {
            return "Checks the convergence in terms of distance to the reference run.";
        }

        public String getExample() {
            return "<!-- The " + this.getParserName() + " element takes a treeModel to be logged -->\n<" + this.getParserName() + " " + "logEvery" + "=\"100\" " + ConvergenceLogger.TREE_FILE_NAME + "=\"log.trees\" " + ConvergenceLogger.REFERENCE_FILE_NAME + "=\"log.trees\" \t<treeModel idref=\"treeModel1\"/>\n</" + this.getParserName() + ">\n";
        }

        public Class getReturnType() {
            return MLLogger.class;
        }
    };

    public ConvergenceLogger(Tree tree, LogFormatter logFormatter, int n, String string, String string2) {
        super(logFormatter, n, false);
        this.referenceTreeFileName = string2;
        this.tree = tree;
        this.outputFilename = string.substring(0, string.indexOf(46)) + ".dist";
        this.taxonMap = new HashMap();
        this.cladeOccurences = new HashMap();
    }

    @Override
    public void startLogging() {
        File file = new File(this.outputFilename.substring(0, this.outputFilename.indexOf(46)) + ".dist");
        if (file.exists()) {
            file.delete();
        }
        this.parseReferenceFile(this.referenceTreeFileName);
        this.taxonArray = new String[this.taxonMap.size()];
        Set<String> set = this.taxonMap.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            this.taxonArray[this.taxonMap.get((Object)string).intValue()] = string = iterator.next();
        }
    }

    private void parseReferenceFile(String string) {
        this.referenceCladeFrequencies = new HashMap();
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            String[] stringArray = string2.split("\\s++");
            long l = Long.parseLong(stringArray[0]);
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray2 = this.getTaxa(string2);
                BitSet bitSet = new BitSet();
                for (String string3 : stringArray2) {
                    if (!this.taxonMap.containsKey(string3)) {
                        this.taxonMap.put(string3, this.taxonMap.size());
                    }
                    bitSet.set(this.taxonMap.get(string3));
                }
                stringArray = string2.split("\\s++");
                double d = 100.0 * (double)Long.parseLong(stringArray[0]) / (double)l;
                this.referenceCladeFrequencies.put(bitSet, d);
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String[] getTaxa(String string) {
        string = string.substring(string.indexOf(40) + 1, string.indexOf(41));
        String[] stringArray = string.split(",");
        return stringArray;
    }

    @Override
    public void log(long l) {
        if (this.logEvery <= 0L || l % this.logEvery == 0L) {
            this.addTree(this.tree);
            if (l % (this.logEvery * 10L) == 0L) {
                double d = this.getMaxCladeDistance();
                try {
                    if (this.bwDistances == null) {
                        this.bwDistances = new BufferedWriter(new FileWriter(this.outputFilename, true));
                    }
                    this.bwDistances.append(l + "\t" + d);
                    this.bwDistances.newLine();
                    this.bwDistances.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void addTree(Tree tree) {
        ++this.trees;
        List<BitSet> list = this.getSplits(tree);
        for (BitSet bitSet : list) {
            if (!this.cladeOccurences.containsKey(bitSet)) {
                this.cladeOccurences.put(bitSet, 1.0);
                continue;
            }
            this.cladeOccurences.put(bitSet, this.cladeOccurences.get(bitSet) + 1.0);
        }
    }

    private List<BitSet> getSplits(Tree tree) {
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        NodeRef nodeRef = tree.getRoot();
        this.fillSplits(arrayList, nodeRef, tree);
        return arrayList;
    }

    private BitSet fillSplits(List<BitSet> list, NodeRef nodeRef, Tree tree) {
        BitSet bitSet = new BitSet();
        if (!tree.isExternal(nodeRef)) {
            bitSet.or(this.fillSplits(list, tree.getChild(nodeRef, 0), tree));
            bitSet.or(this.fillSplits(list, tree.getChild(nodeRef, 1), tree));
            list.add(bitSet);
        } else {
            Taxon taxon = tree.getNodeTaxon(nodeRef);
            String string = taxon.getId();
            bitSet.set(this.taxonMap.get(string));
        }
        return bitSet;
    }

    private double getMaxCladeDistance() {
        return this.getMaxDeviation();
    }

    private double getMaxDeviation() {
        double[] dArray = this.getDeviations();
        double d = 0.0;
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double[] getDeviations() {
        double[] dArray = new double[Math.max(this.referenceCladeFrequencies.size(), this.cladeOccurences.size())];
        Set<BitSet> set = null;
        set = this.referenceCladeFrequencies.size() < this.cladeOccurences.size() ? this.cladeOccurences.keySet() : this.referenceCladeFrequencies.keySet();
        Iterator<BitSet> iterator = set.iterator();
        for (int i = 0; i < dArray.length; ++i) {
            BitSet bitSet = iterator.next();
            double d = 0.0;
            if (this.referenceCladeFrequencies.containsKey(bitSet)) {
                d = this.referenceCladeFrequencies.get(bitSet);
            }
            double d2 = 0.0;
            if (this.cladeOccurences.containsKey(bitSet)) {
                d2 = this.cladeOccurences.get(bitSet);
            }
            dArray[i] = Math.abs(d - d2 * 100.0 / (double)this.trees);
        }
        return dArray;
    }

    @Override
    public void stopLogging() {
        this.logLine("End;");
        super.stopLogging();
    }
}

