/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Deprecated
public class Convergence {
    double distance = Double.MAX_VALUE;
    public static final String LOG_CONVERGENCE = "LogConvergence";
    public static final String TREE_FILE_NAME = "treeFilename";
    public static final String REFERENCE_FILE_NAME = "referenceFilename";
    public static final String CHECK_EVERY = "checkEvery";
    private Tree tree = null;
    private long trees = 0L;
    private HashMap<BitSet, Double> referenceCladeFrequencies = null;
    private HashMap<BitSet, Double> cladeOccurences = null;
    private HashMap<String, Integer> taxonMap;
    private String[] taxonArray;
    private String referenceTreeFileName;
    private double logEvery;

    public Convergence(Tree tree, int n, String string) {
        this.logEvery = n;
        this.referenceTreeFileName = string;
        this.tree = tree;
        this.taxonMap = new HashMap();
        this.cladeOccurences = new HashMap();
        this.startLogging();
    }

    private void startLogging() {
        this.parseReferenceFile(this.referenceTreeFileName);
        this.taxonArray = new String[this.taxonMap.size()];
        Set<String> set = this.taxonMap.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            this.taxonArray[this.taxonMap.get((Object)string).intValue()] = string = iterator.next();
        }
    }

    private void parseReferenceFile(String string) {
        this.referenceCladeFrequencies = new HashMap();
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            String[] stringArray = string2.split("\\s++");
            long l = Long.parseLong(stringArray[0]);
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray2 = this.getTaxa(string2);
                BitSet bitSet = new BitSet();
                for (String string3 : stringArray2) {
                    if (!this.taxonMap.containsKey(string3)) {
                        this.taxonMap.put(string3, this.taxonMap.size());
                    }
                    bitSet.set(this.taxonMap.get(string3));
                }
                stringArray = string2.split("\\s++");
                double d = 100.0 * (double)Long.parseLong(stringArray[0]) / (double)l;
                this.referenceCladeFrequencies.put(bitSet, d);
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String[] getTaxa(String string) {
        string = string.substring(string.indexOf(40) + 1, string.indexOf(41));
        String[] stringArray = string.split(",");
        return stringArray;
    }

    public double log(long l) {
        if (this.logEvery <= 0.0 || (double)l % this.logEvery == 0.0) {
            this.addTree(this.tree);
            this.distance = this.getMaxCladeDistance();
        }
        return this.distance;
    }

    private void addTree(Tree tree) {
        ++this.trees;
        List<BitSet> list = this.getSplits(tree);
        for (BitSet bitSet : list) {
            if (!this.cladeOccurences.containsKey(bitSet)) {
                this.cladeOccurences.put(bitSet, 1.0);
                continue;
            }
            this.cladeOccurences.put(bitSet, this.cladeOccurences.get(bitSet) + 1.0);
        }
    }

    private List<BitSet> getSplits(Tree tree) {
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        NodeRef nodeRef = tree.getRoot();
        this.fillSplits(arrayList, nodeRef, tree);
        return arrayList;
    }

    private BitSet fillSplits(List<BitSet> list, NodeRef nodeRef, Tree tree) {
        BitSet bitSet = new BitSet();
        if (!tree.isExternal(nodeRef)) {
            bitSet.or(this.fillSplits(list, tree.getChild(nodeRef, 0), tree));
            bitSet.or(this.fillSplits(list, tree.getChild(nodeRef, 1), tree));
            list.add(bitSet);
        } else {
            Taxon taxon = tree.getNodeTaxon(nodeRef);
            String string = taxon.getId();
            bitSet.set(this.taxonMap.get(string));
        }
        return bitSet;
    }

    private double getMaxCladeDistance() {
        return this.getMaxDeviation();
    }

    private double getMaxDeviation() {
        double[] dArray = this.getDeviations();
        double d = 0.0;
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double[] getDeviations() {
        double[] dArray = new double[Math.max(this.referenceCladeFrequencies.size(), this.cladeOccurences.size())];
        Set<BitSet> set = null;
        set = this.referenceCladeFrequencies.size() < this.cladeOccurences.size() ? this.cladeOccurences.keySet() : this.referenceCladeFrequencies.keySet();
        Iterator<BitSet> iterator = set.iterator();
        for (int i = 0; i < dArray.length; ++i) {
            BitSet bitSet = iterator.next();
            double d = 0.0;
            if (this.referenceCladeFrequencies.containsKey(bitSet)) {
                d = this.referenceCladeFrequencies.get(bitSet);
            }
            double d2 = 0.0;
            if (this.cladeOccurences.containsKey(bitSet)) {
                d2 = this.cladeOccurences.get(bitSet);
            }
            dArray[i] = Math.abs(d - d2 * 100.0 / (double)this.trees);
        }
        return dArray;
    }
}

