/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.tree.NodeRef;
import dr.evomodel.coalescent.VDdemographicFunction;
import dr.evomodel.speciation.SpeciesTreeModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;

public class SpeciesTreeSimplePrior
extends Likelihood.Abstract {
    private final SpeciesTreeModel sTree;
    private final ParametricDistributionModel tips;
    private final Parameter sigma;
    private static final double d1 = 1.0 - Math.exp(-1.0);
    private static final double f2 = Math.log(Math.sqrt(Math.PI * 2));

    public SpeciesTreeSimplePrior(SpeciesTreeModel speciesTreeModel, Parameter parameter, ParametricDistributionModel parametricDistributionModel) {
        super(new CompoundModel("STprior"));
        this.sTree = speciesTreeModel;
        this.sigma = parameter;
        this.tips = parametricDistributionModel;
        CompoundModel compoundModel = (CompoundModel)this.getModel();
        compoundModel.addModel(parametricDistributionModel);
        compoundModel.addModel(speciesTreeModel);
    }

    @Override
    protected double calculateLogLikelihood() {
        double d = 0.0;
        NodeRef nodeRef = this.sTree.getRoot();
        double d2 = this.sTree.getNodeHeight(nodeRef) + ((VDdemographicFunction)this.sTree.getNodeDemographic(nodeRef)).naturalLimit();
        for (int i = 0; i < this.sTree.getNodeCount(); ++i) {
            NodeRef nodeRef2 = this.sTree.getNode(i);
            DemographicFunction demographicFunction = this.sTree.getNodeDemographic(nodeRef2);
            if (this.sTree.isExternal(nodeRef2)) {
                d += this.tips.logPdf(demographicFunction.getDemographic(0.0));
            }
            double d3 = this.sTree.isRoot(nodeRef2) ? ((VDdemographicFunction)demographicFunction).naturalLimit() : this.sTree.getBranchLength(nodeRef2);
            double d4 = d3 / demographicFunction.getIntegral(0.0, d3);
            double d5 = demographicFunction.getDemographic(d3);
            double d6 = this.sigma.getParameterValue(0) * Math.sqrt((1.0 - Math.exp(-d3 / d2)) / d1);
            double d7 = d5 / d4;
            double d8 = Math.log(d7);
            double d9 = d8 / d6 + d6 / 2.0;
            double d10 = -Math.log(d6) - f2 - d8 - d9 * d9 / 2.0;
            d += d10;
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }
}

