/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.BinaryLatentLiabilityLikelihood;
import dr.evomodel.continuous.IntegratedMultivariateTraitLikelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.util.Citable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class OldLatentLiabilityGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String GIBBS_OPERATOR = "oldLatentLiabilityGibbsOperator";
    private final MutableTreeModel treeModel;
    private final MatrixParameter precisionMatrixParameter;
    private final IntegratedMultivariateTraitLikelihood traitModel;
    private final BinaryLatentLiabilityLikelihood liabilityLikelihood;
    private final int dim;
    private final String traitName;
    private final int maxTries = 10000;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(IntegratedMultivariateTraitLikelihood.class), new ElementRule(BinaryLatentLiabilityLikelihood.class)};

        @Override
        public String getParserName() {
            return OldLatentLiabilityGibbsOperator.GIBBS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            IntegratedMultivariateTraitLikelihood integratedMultivariateTraitLikelihood = (IntegratedMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            BinaryLatentLiabilityLikelihood binaryLatentLiabilityLikelihood = (BinaryLatentLiabilityLikelihood)xMLObject.getChild(BinaryLatentLiabilityLikelihood.class);
            OldLatentLiabilityGibbsOperator oldLatentLiabilityGibbsOperator = new OldLatentLiabilityGibbsOperator(integratedMultivariateTraitLikelihood, binaryLatentLiabilityLikelihood);
            oldLatentLiabilityGibbsOperator.setWeight(d);
            return oldLatentLiabilityGibbsOperator;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a multivariate Gibbs operator on traits for tip nodes under a latent liability model.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public OldLatentLiabilityGibbsOperator(IntegratedMultivariateTraitLikelihood integratedMultivariateTraitLikelihood, BinaryLatentLiabilityLikelihood binaryLatentLiabilityLikelihood) {
        this.traitModel = integratedMultivariateTraitLikelihood;
        this.liabilityLikelihood = binaryLatentLiabilityLikelihood;
        this.treeModel = integratedMultivariateTraitLikelihood.getTreeModel();
        this.precisionMatrixParameter = (MatrixParameter)integratedMultivariateTraitLikelihood.getDiffusionModel().getPrecisionParameter();
        this.traitName = integratedMultivariateTraitLikelihood.getTraitName();
        this.dim = integratedMultivariateTraitLikelihood.getDimTrait();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Using a latent trait Gibbs operator.  Please cite:");
        stringBuilder.append(Citable.Utils.getCitationString(binaryLatentLiabilityLikelihood));
        Logger.getLogger("dr.evomodel.continuous").info(stringBuilder.toString());
    }

    public int getStepCount() {
        return 1;
    }

    @Override
    public double doOperation() {
        this.traitModel.redrawAncestralStates();
        NodeRef nodeRef = this.treeModel.getNode(MathUtils.nextInt(this.treeModel.getExternalNodeCount()));
        int n = nodeRef.getNumber();
        while (!this.liabilityLikelihood.validTraitForTip(n)) {
        }
        return 0.0;
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    @Override
    public String getOperatorName() {
        return GIBBS_OPERATOR;
    }

    class MeanPrecision {
        final double[] mean;
        final double[][] precision;

        MeanPrecision(double[] dArray, double[][] dArray2) {
            this.mean = dArray;
            this.precision = dArray2;
        }
    }
}

