/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous.hmc;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.hmc.TreePrecisionTraitProductProvider;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitDataModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.ElementaryVectorDataModel;
import dr.inference.hmc.PrecisionColumnProvider;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedVector;
import dr.xml.Reportable;
import java.util.HashMap;
import java.util.Map;

public class TreePrecisionColumnProvider
extends AbstractModel
implements PrecisionColumnProvider,
Reportable {
    private final TreePrecisionTraitProductProvider productProvider;
    final Tree tree;
    private final ContinuousDataLikelihoodDelegate likelihoodDelegate;
    private final ContinuousTraitPartialsProvider tipData;
    private final Map<Integer, double[]> treeCache = new HashMap<Integer, double[]>();
    private final int numTaxa;
    private final int dimTrait;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_CACHE = false;
    private static final boolean RESET_DATA = false;

    public TreePrecisionColumnProvider(TreePrecisionTraitProductProvider treePrecisionTraitProductProvider) {
        super("treePrecisionColumnProvider");
        this.productProvider = treePrecisionTraitProductProvider;
        this.tree = treePrecisionTraitProductProvider.getTree();
        this.likelihoodDelegate = treePrecisionTraitProductProvider.likelihoodDelegate;
        this.tipData = treePrecisionTraitProductProvider.getDataModel();
        this.numTaxa = this.tree.getExternalNodeCount();
        this.dimTrait = this.likelihoodDelegate.getTraitDim();
        assert (this.likelihoodDelegate.getTraitCount() == 1);
        if (this.tree instanceof Model) {
            this.addModel((Model)((Object)this.tree));
        }
    }

    @Override
    public double[] getColumn(int n) {
        double[] dArray = this.treeCache.get(n);
        if (dArray == null) {
            dArray = this.setDataModelAndGetColumn(n);
            this.treeCache.put(n, dArray);
        }
        return dArray;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.clearTreeCache();
        }
    }

    protected void clearTreeCache() {
        this.treeCache.clear();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    private double[] setDataModelAndGetColumn(int n) {
        Object object;
        CompoundParameter compoundParameter = this.tipData.getParameter();
        if (this.tipData instanceof ContinuousTraitDataModel) {
            ReadableVector.Utils.setParameter((ReadableVector)this.makeElementaryVector(n), (Parameter)this.tipData.getParameter());
        } else if (this.tipData instanceof ElementaryVectorDataModel) {
            object = (ElementaryVectorDataModel)this.tipData;
            int n2 = n / this.dimTrait;
            int n3 = n % this.dimTrait;
            ((ElementaryVectorDataModel)object).setTipTraitDimParameters(n2, 0, n3);
        } else {
            throw new RuntimeException("Not yet implemented");
        }
        object = this.productProvider.getProduct(compoundParameter);
        return object;
    }

    private WrappedVector makeElementaryVector(int n) {
        double[] dArray = new double[this.numTaxa * this.dimTrait];
        dArray[n] = 1.0;
        return new WrappedVector.Raw(dArray);
    }

    private double[] expensiveColumn(int n) {
        return this.likelihoodDelegate.getTreeTraitPrecision()[n];
    }

    private void debug(double[] dArray, int n) {
        double[] dArray2 = this.expensiveColumn(n);
        System.err.println("via FCD: " + new WrappedVector.Raw(dArray));
        System.err.println("direct : " + new WrappedVector.Raw(dArray2));
        System.err.println();
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.numTaxa; ++i) {
            for (int j = 0; j < this.dimTrait; ++j) {
                stringBuilder.append(new WrappedVector.Raw(this.getColumn(i * this.dimTrait + j))).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

