/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.DiffusionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TraitLikelihood
extends AbstractModelLikelihood {
    public static final String TRAIT_LIKELIHOOD = "traitLikelihood";
    public static final String TRAIT_NAME = "traitName";
    public static final String JEFFERYS_PRIOR = "jefferysPrior";
    public static final String MODEL = "model";
    public static final String TREE = "tree";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("traitName", "The name of the trait for which a likelihood should be calculated"), AttributeRule.newBooleanRule("jefferysPrior"), new ElementRule(DiffusionModel.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return TraitLikelihood.TRAIT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DiffusionModel diffusionModel = (DiffusionModel)xMLObject.getChild(DiffusionModel.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            String string = xMLObject.getStringAttribute(TraitLikelihood.TRAIT_NAME);
            boolean bl = xMLObject.getBooleanAttribute(TraitLikelihood.JEFFERYS_PRIOR);
            return new TraitLikelihood(treeModel, diffusionModel, string, bl);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a continuous trait evolving on a tree by a given diffusion model.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return TraitLikelihood.class;
        }
    };
    TreeModel treeModel = null;
    DiffusionModel diffusionModel = null;
    String traitName = null;
    private boolean jeffreysPrior = false;
    ArrayList dataList = new ArrayList();
    private double logLikelihood;
    private double maxLogLikelihood = Double.NEGATIVE_INFINITY;
    private double storedLogLikelihood;
    private boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;

    public TraitLikelihood(TreeModel treeModel, DiffusionModel diffusionModel, String string, boolean bl) {
        super(TRAIT_LIKELIHOOD);
        this.treeModel = treeModel;
        this.diffusionModel = diffusionModel;
        this.jeffreysPrior = bl;
        this.addModel(treeModel);
        this.addModel(diffusionModel);
        this.traitName = string;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    public double calculateLogLikelihood() {
        double d = this.traitLogLikelihood(this.treeModel.getRoot());
        if (d > this.maxLogLikelihood) {
            this.maxLogLikelihood = d;
        }
        return d;
    }

    public double getMaxLogLikelihood() {
        return this.maxLogLikelihood;
    }

    private double traitLogLikelihood(NodeRef nodeRef) {
        double d = 0.0;
        if (!this.treeModel.isRoot(nodeRef)) {
            NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
            Double d2 = (Double)this.treeModel.getNodeAttribute(nodeRef2, this.traitName);
            Double d3 = (Double)this.treeModel.getNodeAttribute(nodeRef, this.traitName);
            double d4 = this.treeModel.getNodeHeight(nodeRef2) - this.treeModel.getNodeHeight(nodeRef);
            d = this.diffusionModel.getLogLikelihood(d2, d3, d4);
        }
        int n = this.treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            d += this.traitLogLikelihood(this.treeModel.getChild(nodeRef, i));
        }
        if (this.jeffreysPrior) {
            d += Math.log(1.0 / this.diffusionModel.getD());
        }
        return d;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }
}

