/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.BranchSpecificFixedEffects;
import dr.evomodel.branchratemodel.DifferentiableBranchRates;
import dr.evomodel.branchratemodel.NodeRateMap;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleBinaryOperator;

public class LocationScaledBranchRateModel
extends AbstractBranchRateModel
implements DifferentiableBranchRates,
Citable {
    private final TreeModel treeModel;
    private final BranchRateModel branchRateModel;
    private final DifferentiableBranchRates differentiableBranchRateModel;
    private final BranchSpecificFixedEffects location;

    public LocationScaledBranchRateModel(TreeModel treeModel, BranchRateModel branchRateModel, BranchSpecificFixedEffects branchSpecificFixedEffects) {
        super("name");
        this.treeModel = treeModel;
        this.branchRateModel = branchRateModel;
        this.differentiableBranchRateModel = branchRateModel instanceof DifferentiableBranchRates ? (DifferentiableBranchRates)((Object)branchRateModel) : null;
        this.location = branchSpecificFixedEffects;
        this.addModel(treeModel);
        this.addModel(branchRateModel);
        if (branchSpecificFixedEffects instanceof Model) {
            this.addModel((Model)((Object)branchSpecificFixedEffects));
        }
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRateDifferential(Tree tree, NodeRef nodeRef) {
        this.checkDifferentiability();
        return this.location.getEffect(tree, nodeRef) * this.differentiableBranchRateModel.getBranchRateDifferential(tree, nodeRef);
    }

    @Override
    public double getBranchRateSecondDifferential(Tree tree, NodeRef nodeRef) {
        this.checkDifferentiability();
        return this.location.getEffect(tree, nodeRef) * this.differentiableBranchRateModel.getBranchRateSecondDifferential(tree, nodeRef);
    }

    @Override
    public Parameter getRateParameter() {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.getRateParameter();
    }

    @Override
    public Tree getTree() {
        return this.treeModel;
    }

    @Override
    public int getParameterIndexFromNode(NodeRef nodeRef) {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.getParameterIndexFromNode(nodeRef);
    }

    private void checkDifferentiability() {
        if (this.differentiableBranchRateModel == null) {
            throw new RuntimeException("Non-differentiable base BranchRateModel");
        }
    }

    @Override
    public ArbitraryBranchRates.BranchRateTransform getTransform() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] updateGradientLogDensity(double[] dArray, double[] dArray2, int n, int n2) {
        return dArray;
    }

    @Override
    public double[] updateDiagonalHessianLogDensity(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mapReduceOverRates(NodeRateMap nodeRateMap, DoubleBinaryOperator doubleBinaryOperator, double d) {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.mapReduceOverRates(nodeRateMap, doubleBinaryOperator, d);
    }

    @Override
    public void forEachOverRates(NodeRateMap nodeRateMap) {
        this.checkDifferentiability();
        this.differentiableBranchRateModel.forEachOverRates(nodeRateMap);
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (tree == this.treeModel);
        return this.location.getEffect(tree, nodeRef) * this.branchRateModel.getBranchRate(tree, nodeRef);
    }

    public double getLocation(Tree tree, NodeRef nodeRef) {
        return this.location.getEffect(tree, nodeRef);
    }

    @Override
    public double getUntransformedBranchRate(Tree tree, NodeRef nodeRef) {
        this.checkDifferentiability();
        return this.differentiableBranchRateModel.getUntransformedBranchRate(tree, nodeRef);
    }

    public double getPriorRateAsIncrement(Tree tree) {
        return Math.log(this.location.getEffect(tree, null));
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MOLECULAR_CLOCK;
    }

    @Override
    public String getDescription() {
        String string = this.branchRateModel instanceof Citable ? ((Citable)((Object)this.branchRateModel)).getDescription() : "Unknown clock model";
        string = string + " with scaling-by-tree-time";
        return string;
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = this.branchRateModel instanceof Citable ? new ArrayList<Citation>(((Citable)((Object)this.branchRateModel)).getCitations()) : new ArrayList();
        return arrayList;
    }
}

