/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.Collections;
import java.util.List;

public class HomogeneousBranchModel
extends AbstractModel
implements BranchModel {
    private final SubstitutionModel substitutionModel;
    private final FrequencyModel rootFrequencyModel;

    public HomogeneousBranchModel(SubstitutionModel substitutionModel) {
        this(substitutionModel, null);
    }

    public HomogeneousBranchModel(SubstitutionModel substitutionModel, FrequencyModel frequencyModel) {
        super("HomogeneousBranchModel");
        this.substitutionModel = substitutionModel;
        this.addModel(substitutionModel);
        if (frequencyModel != null) {
            this.addModel(frequencyModel);
            this.rootFrequencyModel = frequencyModel;
        } else {
            this.rootFrequencyModel = substitutionModel.getFrequencyModel();
        }
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        return DEFAULT;
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return Collections.singletonList(this.substitutionModel);
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        return this.substitutionModel;
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.rootFrequencyModel;
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

