/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.arg.ARGModel;
import dr.util.Attributable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ARGTree
implements Tree {
    protected Taxon[] taxaList;
    protected int taxaCount;
    private final ARGModel.Node initialRoot;
    public ARGModel argModel;
    private final Map<NodeRef, NodeRef> mapARGNodesToTreeNodes;
    private int partition = -9;
    protected String id = null;
    private Attributable.AttributeHelper treeAttributes = null;
    protected ARGModel.Node root = null;
    protected int storedRootNumber;
    protected ARGModel.Node[] nodes = null;
    protected ARGModel.Node[] storedNodes = null;
    protected int nodeCount;
    protected int externalNodeCount;
    protected int internalNodeCount;
    private Units.Type units;
    protected boolean inEdit = false;
    private final boolean hasRates;
    private final boolean hasTraits = false;

    public boolean wasRootTrimmed() {
        return this.root != this.initialRoot;
    }

    public String toGraphString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ARGModel.Node node : this.nodes) {
            stringBuffer.append(node.number);
            if (node.leftParent != null) {
                stringBuffer.append(" " + node.leftParent.number);
            } else {
                stringBuffer.append(" 0");
            }
            if (node.rightParent != null) {
                stringBuffer.append(" " + node.rightParent.number);
            } else {
                stringBuffer.append(" 0");
            }
            if (node.leftChild != null) {
                stringBuffer.append(" " + node.leftChild.number);
            } else {
                stringBuffer.append(" 0");
            }
            if (node.rightChild != null) {
                stringBuffer.append(" " + node.rightChild.number);
            } else {
                stringBuffer.append(" 0");
            }
            if (node.taxon != null) {
                stringBuffer.append(" " + node.taxon.toString());
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("Root = " + ((ARGModel.Node)this.getRoot()).number + "\n");
        return new String(stringBuffer);
    }

    public ARGTree(ARGModel aRGModel, int n) {
        ARGModel.Node node;
        this.argModel = aRGModel;
        this.mapARGNodesToTreeNodes = new HashMap<NodeRef, NodeRef>(aRGModel.getNodeCount());
        this.partition = n;
        ARGModel aRGModel2 = aRGModel;
        Objects.requireNonNull(aRGModel2);
        this.initialRoot = node = aRGModel2.new ARGModel.Node((ARGModel.Node)aRGModel.getRoot(), n);
        int n2 = aRGModel.externalNodeCount;
        node.stripOutDeadEnds();
        node = this.root = node.stripOutSingleChildNodes(node);
        this.nodeCount = 2 * n2 - 1;
        this.externalNodeCount = n2;
        this.internalNodeCount = n2 - 1;
        this.nodes = new ARGModel.Node[this.nodeCount];
        do {
            if ((node = (ARGModel.Node)TreeUtils.postorderSuccessor(this, node)).isExternal()) {
                this.nodes[node.number] = node;
                this.mapARGNodesToTreeNodes.put(node.mirrorNode, node);
                continue;
            }
            this.nodes[n2] = node;
            node.number = n2++;
            this.mapARGNodesToTreeNodes.put(node.mirrorNode, node);
        } while (node != this.root);
        this.hasRates = false;
    }

    public Map<NodeRef, NodeRef> getMapping() {
        return this.mapARGNodesToTreeNodes;
    }

    public boolean checkForNullRights(ARGModel.Node node) {
        return node.checkForNullRights();
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public final int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public final boolean hasNodeHeights() {
        return true;
    }

    @Override
    public final double getNodeHeight(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).getHeight();
    }

    public final double getNodeHeightUpper(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).heightParameter.getBounds().getUpperLimit(0);
    }

    public final double getNodeHeightLower(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).heightParameter.getBounds().getLowerLimit(0);
    }

    @Override
    public final double getNodeRate(NodeRef nodeRef) {
        if (!this.hasRates) {
            return 1.0;
        }
        return ((ARGModel.Node)nodeRef).getRate(this.partition);
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("TreeModel does not use NodeAttributes");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new UnsupportedOperationException("TreeModel does not use NodeAttributes");
    }

    public double getNodeTrait(NodeRef nodeRef) {
        throw new IllegalArgumentException("Trait parameters have not been created");
    }

    @Override
    public final Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).taxon;
    }

    @Override
    public final boolean isExternal(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).isExternal();
    }

    @Override
    public final boolean isRoot(NodeRef nodeRef) {
        return nodeRef == this.root;
    }

    @Override
    public final int getChildCount(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).getChildCount();
    }

    @Override
    public final NodeRef getChild(NodeRef nodeRef, int n) {
        return ((ARGModel.Node)nodeRef).getChild(n);
    }

    @Override
    public final NodeRef getParent(NodeRef nodeRef) {
        return ((ARGModel.Node)nodeRef).leftParent;
    }

    @Override
    public final boolean hasBranchLengths() {
        return true;
    }

    @Override
    public final double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.getParent(nodeRef);
        if (nodeRef2 == null) {
            return 0.0;
        }
        return this.getNodeHeight(nodeRef2) - this.getNodeHeight(nodeRef);
    }

    @Override
    public final NodeRef getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public final NodeRef getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public final NodeRef getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public final int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public final int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public final NodeRef getRoot() {
        return this.root;
    }

    @Override
    public int getTaxonCount() {
        return this.getExternalNodeCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((ARGModel.Node)this.getExternalNode((int)n)).taxon;
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        return null;
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < ARGTree.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return ARGTree.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public final Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return null;
    }

    public int addTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a TreeModel");
    }

    public boolean removeTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a TreeModel");
    }

    public void setTaxonId(int n, String string) {
        throw new IllegalArgumentException("Cannot set taxon id in a TreeModel");
    }

    public void setTaxonAttribute(int n, String string, Object object) {
        throw new IllegalArgumentException("Cannot set taxon attribute in a TreeModel");
    }

    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
    }

    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.treeAttributes == null) {
            this.treeAttributes = new Attributable.AttributeHelper();
        }
        this.treeAttributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttributeNames();
    }

    public final String getNewick() {
        return TreeUtils.newick(this);
    }

    public final String getUniqueNewick() {
        return TreeUtils.uniqueNewick(this, this.getRoot());
    }

    public String toString() {
        return this.getNewick();
    }

    @Override
    public Tree getCopy() {
        throw new UnsupportedOperationException("please don't call this function");
    }
}

