/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.alloppnet.speciation.AlloppDiploidHistory;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppMulLabTree;
import dr.evomodel.alloppnet.speciation.AlloppNode;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.tree.TreeLogger;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.Scalable;
import dr.math.MathUtils;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import jebl.util.FixedBitSet;

public class AlloppSpeciesNetworkModel
extends AbstractModel
implements Scalable,
Units,
Citable,
Tree,
TreeTraitProvider,
TreeLogger.LogUpon {
    private final AlloppSpeciesBindings apsp;
    private AlloppDiploidHistory adhist;
    private AlloppDiploidHistory oldadhist;
    private ArrayList<AlloppLeggedTree> tettrees;
    private ArrayList<AlloppLeggedTree> oldtettrees;
    private int nofdiploids;
    private int noftetraploids;
    private boolean onehybridization;
    private boolean diploidrootisroot;
    private TreeTrait tti;
    private TreeTrait hh;
    private AlloppMulLabTree mullabtree;
    private ParametricDistributionModel hybridPopModel;
    public final Parameter tippopvalues;
    public final Parameter rootpopvalues;
    public final Parameter logginghybpopvalues;
    private double[] hybpopvalues;
    private double[] oldhybpopvalues;
    public static final boolean DBUGTUNE = false;

    public AlloppSpeciesNetworkModel(AlloppSpeciesBindings alloppSpeciesBindings, double d, double d2, double d3, boolean bl, boolean bl2) {
        super("alloppSpeciesNetwork");
        this.apsp = alloppSpeciesBindings;
        this.addModel(this.apsp);
        this.tettrees = new ArrayList();
        Taxon[] taxonArray = this.apsp.SpeciesWithinPloidyLevel(2);
        this.nofdiploids = taxonArray.length;
        Taxon[] taxonArray2 = this.apsp.SpeciesWithinPloidyLevel(4);
        this.noftetraploids = taxonArray2.length;
        this.onehybridization = bl;
        this.diploidrootisroot = bl2;
        this.makeInitialNDipsNTetsNetwork(taxonArray, taxonArray2);
        double d4 = this.adhist.getRootHeight();
        for (int i = 0; i < this.tettrees.size(); ++i) {
            double d5 = this.tettrees.get(i).getRootHeight();
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        double d6 = 0.99 * this.apsp.initialMinGeneNodeHeight() / d4;
        this.scaleAllHeights(d6);
        int n = this.numberOfTipPopParameters();
        int n2 = this.numberOfRootPopParameters();
        int n3 = this.maxNumberOfHybPopParameters();
        this.tippopvalues = new Parameter.Default(n, d);
        this.rootpopvalues = new Parameter.Default(n2, d2);
        this.addVariable(this.tippopvalues);
        this.addVariable(this.rootpopvalues);
        this.hybpopvalues = new double[n3];
        for (int i = 0; i < this.hybpopvalues.length; ++i) {
            this.hybpopvalues[i] = d3;
        }
        this.logginghybpopvalues = new Parameter.Default(this.hybpopvalues);
        this.makeLoggingHybPopParam();
        this.mullabtree = new AlloppMulLabTree(this.adhist, this.tettrees, this.apsp, this.tippopvalues, this.rootpopvalues, this.hybpopvalues);
        this.tti = new TetTreeIndexTrait();
        this.hh = new HybHeightTrait();
        Logger.getLogger("dr.evomodel.speciation.allopolyploid").info("\tConstructing an allopolyploid network,  please cite:\n" + Citable.Utils.getCitationString(this));
    }

    public AlloppSpeciesNetworkModel(AlloppSpeciesBindings alloppSpeciesBindings) {
        super("alloppSpeciesNetwork");
        this.apsp = alloppSpeciesBindings;
        this.tippopvalues = null;
        this.rootpopvalues = null;
        this.hybpopvalues = null;
        this.logginghybpopvalues = null;
    }

    public void setHybPopModel(ParametricDistributionModel parametricDistributionModel) {
        this.hybridPopModel = parametricDistributionModel;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SPECIES_MODELS;
    }

    @Override
    public String getDescription() {
        return "Allopolyploid Species Networks";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(new Citation(new Author[]{new Author("Graham", "Jones"), new Author("Serik", "Sagitov"), new Author("Bengt", "Oxelman")}, "Statistical Inference of Allopolyploid Species Networks in the Presence of Incomplete Lineage Sorting", 2013, "Systematic Biology", 62, 467, 478, Citation.Status.PUBLISHED));
    }

    public boolean alloppspeciesnetworkOK() {
        for (AlloppLeggedTree alloppLeggedTree : this.tettrees) {
            if (alloppLeggedTree.leggedtreeOK()) continue;
            return false;
        }
        for (int i = 0; i < this.tettrees.size(); ++i) {
            AlloppLeggedTree alloppLeggedTree;
            alloppLeggedTree = this.getTetraploidTree(i);
            int n = alloppLeggedTree.getDiphistLftLeg();
            int n2 = alloppLeggedTree.getDiphistRgtLeg();
            if (AlloppDiploidHistory.LegLorR.left != this.adhist.getNodeLeg(n)) {
                return false;
            }
            if (i != this.adhist.getNodeTettree(n)) {
                return false;
            }
            if (AlloppDiploidHistory.LegLorR.right != this.adhist.getNodeLeg(n2)) {
                return false;
            }
            if (i == this.adhist.getNodeTettree(n2)) continue;
            return false;
        }
        if (!this.adhist.diphistOK(this.diploidrootisroot)) {
            return false;
        }
        return this.mullabtree.mullabtreeOK();
    }

    String mullabTreeAsText() {
        return this.mullabtree.asText();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        int n;
        this.oldtettrees = new ArrayList();
        for (n = 0; n < this.tettrees.size(); ++n) {
            this.oldtettrees.add(new AlloppLeggedTree(this.tettrees.get(n)));
        }
        this.oldadhist = new AlloppDiploidHistory(this.adhist);
        this.oldhybpopvalues = new double[this.hybpopvalues.length];
        for (n = 0; n < this.oldhybpopvalues.length; ++n) {
            this.oldhybpopvalues[n] = this.hybpopvalues[n];
        }
    }

    @Override
    protected void restoreState() {
        int n;
        this.tettrees = new ArrayList();
        for (n = 0; n < this.oldtettrees.size(); ++n) {
            this.tettrees.add(new AlloppLeggedTree(this.oldtettrees.get(n)));
        }
        this.adhist = new AlloppDiploidHistory(this.oldadhist);
        this.hybpopvalues = new double[this.oldhybpopvalues.length];
        for (n = 0; n < this.hybpopvalues.length; ++n) {
            this.hybpopvalues[n] = this.oldhybpopvalues[n];
        }
        this.makeLoggingHybPopParam();
        this.mullabtree = new AlloppMulLabTree(this.adhist, this.tettrees, this.apsp, this.tippopvalues, this.rootpopvalues, this.hybpopvalues);
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public String toString() {
        int n;
        int n2 = this.apsp.numberOfGeneTrees();
        String string = System.getProperty("line.separator");
        String string2 = string + this.adhist.asText() + string;
        string2 = string2 + "noftettrees " + this.tettrees.size() + string;
        for (n = 0; n < this.tettrees.size(); ++n) {
            string2 = string2 + this.tettrees.get(n).asText(n);
        }
        string2 = string2 + this.mullabtree.asText() + string;
        for (n = 0; n < n2; ++n) {
            string2 = string2 + this.apsp.genetreeAsText(n);
            string2 = string2 + this.apsp.seqassignsAsText(n) + string;
        }
        string2 = string2 + string;
        return string2;
    }

    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[]{new LogColumn.Default("    MUL-tree and gene trees", this)};
        return logColumnArray;
    }

    public boolean beginNetworkEdit() {
        assert (this.alloppspeciesnetworkOK());
        boolean bl = false;
        return bl;
    }

    public void endNetworkEdit() {
        this.makeLoggingHybPopParam();
        this.mullabtree = new AlloppMulLabTree(this.adhist, this.tettrees, this.apsp, this.tippopvalues, this.rootpopvalues, this.hybpopvalues);
        assert (this.alloppspeciesnetworkOK());
        this.fireModelChanged();
    }

    public boolean netAndGTreesAreCompatible() {
        for (int i = 0; i < this.apsp.numberOfGeneTrees(); ++i) {
            if (this.apsp.geneTreeFitsInNetwork(i, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.getModelName();
    }

    @Override
    public int scale(double d, int n, boolean bl) {
        assert (d > 0.0);
        assert (n <= 0);
        if (n <= 0) {
            this.beginNetworkEdit();
            int n2 = 0;
            n2 += this.scaleAllHeights(d);
            this.endNetworkEdit();
            this.fireModelChanged(this, 1);
            return n2 += this.scaleAllPopValues(d);
        }
        if (n != 1) {
            throw new UnsupportedOperationException("not implemented for count != 1");
        }
        this.fireModelChanged(this, 1);
        return n;
    }

    @Override
    public boolean testBounds() {
        return true;
    }

    public FixedBitSet calculateDipHistTipUnion(NodeRef nodeRef) {
        if (nodeRef == null) {
            System.out.println("BUG in calculateDipHistTipUnion()");
        }
        assert (nodeRef != null);
        int n = this.adhist.getNodeTettree(nodeRef.getNumber());
        AlloppDiploidHistory.LegLorR legLorR = this.adhist.getNodeLeg(nodeRef.getNumber());
        int n2 = legLorR == AlloppDiploidHistory.LegLorR.left ? 0 : 1;
        FixedBitSet fixedBitSet = n < 0 ? this.apsp.taxonseqToTipUnion(this.adhist.getSlidableNodeTaxon(nodeRef), 0) : this.unionOfWholeTetTree(n, n2);
        return fixedBitSet;
    }

    public FixedBitSet unionOfWholeTetTree(int n, int n2) {
        this.tettrees.get(n).fillinTipUnions(this.apsp, n2);
        AlloppNode alloppNode = (AlloppNode)((Object)this.tettrees.get(n).getSlidableRoot());
        alloppNode.fillinUnionsInSubtree(this.apsp.numberOfSpSeqs());
        return alloppNode.getUnion();
    }

    public double addHybPopParam() {
        assert (this.tettrees.size() <= this.hybpopvalues.length);
        double d = this.hybridPopModel.quantile(MathUtils.nextDouble());
        if (d < 1.0E-10) {
            d = 1.0E-10;
        }
        this.hybpopvalues[this.tettrees.size() - 1] = d;
        return this.hybridPopModel.logPdf(d);
    }

    public double removeHybPopParam() {
        assert (this.tettrees.size() < this.hybpopvalues.length);
        double d = this.hybpopvalues[this.tettrees.size()];
        this.hybpopvalues[this.tettrees.size()] = 0.0;
        return this.hybridPopModel.logPdf(d);
    }

    public int getNumberOfTetraTrees() {
        return this.tettrees.size();
    }

    public boolean getDiploidRootIsRoot() {
        return this.diploidrootisroot;
    }

    public boolean getOneHybridization() {
        return this.onehybridization;
    }

    public int getNumberOfInternalNodesInTetTree(int n) {
        return this.tettrees.get(n).getInternalNodeCount();
    }

    public int getNumberOfInternalNodesInDipHist() {
        return this.adhist.getInternalNodeCount();
    }

    public AlloppLeggedTree getTetraploidTree(int n) {
        return this.tettrees.get(n);
    }

    public AlloppDiploidHistory getDiploidHistory() {
        return this.adhist;
    }

    public int getNofDiploids() {
        return this.nofdiploids;
    }

    public void setTetTree(int n, AlloppLeggedTree alloppLeggedTree) {
        this.tettrees.set(n, alloppLeggedTree);
    }

    public int addTetTree(AlloppLeggedTree alloppLeggedTree) {
        this.tettrees.add(alloppLeggedTree);
        return this.tettrees.size() - 1;
    }

    public void removeTetree(int n) {
        this.tettrees.remove(n);
    }

    public void flipLegsOfTetraTree(int n) {
        int n2 = this.tettrees.get(n).getDiphistLftLeg();
        int n3 = this.tettrees.get(n).getDiphistRgtLeg();
        AlloppDiploidHistory.LegLorR legLorR = this.adhist.getNodeLeg(n2);
        AlloppDiploidHistory.LegLorR legLorR2 = this.adhist.getNodeLeg(n3);
        this.adhist.setNodeLeg(n2, legLorR2);
        this.adhist.setNodeLeg(n3, legLorR);
        this.tettrees.get(n).setDiphistLftLeg(n3);
        this.tettrees.get(n).setDiphistRgtLeg(n2);
    }

    public void moveLegs() {
    }

    public int maxNumberOfHybPopParameters() {
        return this.apsp.SpeciesWithinPloidyLevel(4).length;
    }

    public void setOneHybPopValue(int n, double d) {
        this.hybpopvalues[n] = d;
    }

    Parameter getTipPopValues() {
        return this.tippopvalues;
    }

    Parameter getRootPopValues() {
        return this.rootpopvalues;
    }

    public double getOneHybPopValue(int n) {
        return this.hybpopvalues[n];
    }

    boolean coalescenceIsCompatible(double d, FixedBitSet fixedBitSet) {
        boolean bl = this.mullabtree.coalescenceIsCompatible(d, fixedBitSet);
        return bl;
    }

    void clearCoalescences() {
        this.mullabtree.clearCoalescences();
    }

    void recordCoalescence(double d, FixedBitSet fixedBitSet) {
        this.mullabtree.recordCoalescence(d, fixedBitSet);
    }

    void sortCoalescences() {
        this.mullabtree.sortCoalescences();
    }

    void recordLineageCounts() {
        this.mullabtree.recordLineageCounts();
    }

    double geneTreeInNetworkLogLikelihood() {
        return this.mullabtree.geneTreeInMULTreeLogLikelihood();
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return new TreeTrait[]{this.tti};
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        if (string.equals(this.tti.getTraitName())) {
            return this.tti;
        }
        if (string.equals(this.hh.getTraitName())) {
            return this.hh;
        }
        throw new IllegalArgumentException();
    }

    private void makeInitialNDipsNTetsNetwork(Taxon[] taxonArray, Taxon[] taxonArray2) {
        Object[] objectArray;
        int n;
        double d = 1.0;
        assert (taxonArray2.length > 0);
        assert (taxonArray.length > 1);
        ArrayList<TetraTaxonGroup> arrayList = new ArrayList<TetraTaxonGroup>();
        TetraTaxonGroup tetraTaxonGroup = new TetraTaxonGroup();
        if (this.onehybridization) {
            for (n = 0; n < taxonArray2.length; ++n) {
                tetraTaxonGroup.add(taxonArray2[n]);
            }
            arrayList.add(tetraTaxonGroup);
        } else {
            tetraTaxonGroup.add(taxonArray2[0]);
            arrayList.add(tetraTaxonGroup);
            for (n = 1; n < taxonArray2.length; ++n) {
                int n2;
                objectArray = new double[arrayList.size() + 1];
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    objectArray[n2] = ((TetraTaxonGroup)arrayList.get(n2)).size();
                }
                objectArray[arrayList.size()] = 1.0;
                n2 = MathUtils.randomChoicePDF(objectArray);
                if (n2 == arrayList.size()) {
                    TetraTaxonGroup tetraTaxonGroup2 = new TetraTaxonGroup();
                    tetraTaxonGroup2.add(taxonArray2[n]);
                    arrayList.add(tetraTaxonGroup2);
                    continue;
                }
                ((TetraTaxonGroup)arrayList.get(n2)).add(taxonArray2[n]);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            objectArray = new Taxon[((TetraTaxonGroup)arrayList.get(n)).size()];
            for (int i = 0; i < ((TetraTaxonGroup)arrayList.get(n)).size(); ++i) {
                objectArray[i] = (double)((TetraTaxonGroup)arrayList.get(n)).get(i);
            }
            AlloppLeggedTree alloppLeggedTree = new AlloppLeggedTree((Taxon[])objectArray, d);
            this.tettrees.add(alloppLeggedTree);
        }
        this.adhist = new AlloppDiploidHistory(taxonArray, this.tettrees, this.diploidrootisroot, d, this.apsp);
    }

    private void makeLoggingHybPopParam() {
        for (int i = 0; i < this.hybpopvalues.length; ++i) {
            this.logginghybpopvalues.setParameterValueQuietly(i, this.hybpopvalues[i]);
        }
    }

    private int scaleAllPopValues(double d) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.tippopvalues.getDimension(); ++n) {
            this.tippopvalues.setParameterValue(n, d * this.tippopvalues.getParameterValue(n));
            ++n2;
        }
        for (n = 0; n < this.rootpopvalues.getDimension(); ++n) {
            this.rootpopvalues.setParameterValue(n, d * this.rootpopvalues.getParameterValue(n));
            ++n2;
        }
        n = 0;
        while (n < this.tettrees.size()) {
            int n3 = n++;
            this.hybpopvalues[n3] = this.hybpopvalues[n3] * d;
            ++n2;
        }
        return n2;
    }

    private int scaleAllHeights(double d) {
        int n = this.adhist.scaleAllHeights(d);
        for (int i = 0; i < this.tettrees.size(); ++i) {
            n += this.tettrees.get(i).scaleAllHeights(d);
        }
        return n;
    }

    private int numberOfTipPopParameters() {
        int n = this.apsp.SpeciesWithinPloidyLevel(2).length;
        int n2 = this.apsp.SpeciesWithinPloidyLevel(4).length;
        return n + n2;
    }

    private int numberOfRootPopParameters() {
        int n = this.apsp.SpeciesWithinPloidyLevel(2).length;
        int n2 = this.apsp.SpeciesWithinPloidyLevel(4).length;
        return 2 * (n + n2 - 1);
    }

    @Override
    public int getTaxonCount() {
        return this.mullabtree.simptree.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.mullabtree.simptree.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.mullabtree.simptree.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.mullabtree.simptree.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.mullabtree.simptree.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        return this.mullabtree.simptree.asList();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.mullabtree.simptree.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.mullabtree.simptree.getId();
    }

    @Override
    public void setId(String string) {
        this.mullabtree.simptree.setId(string);
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.mullabtree.simptree.iterator();
    }

    @Override
    public Units.Type getUnits() {
        return this.mullabtree.simptree.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.mullabtree.simptree.setUnits(type);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.mullabtree.simptree.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        return this.mullabtree.simptree.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.mullabtree.simptree.getAttributeNames();
    }

    @Override
    public NodeRef getRoot() {
        return this.mullabtree.simptree.getRoot();
    }

    @Override
    public int getNodeCount() {
        return this.mullabtree.simptree.getNodeCount();
    }

    @Override
    public NodeRef getNode(int n) {
        return this.mullabtree.simptree.getNode(n);
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.mullabtree.simptree.getInternalNode(n);
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.mullabtree.simptree.getExternalNode(n);
    }

    @Override
    public int getExternalNodeCount() {
        return this.mullabtree.simptree.getExternalNodeCount();
    }

    @Override
    public int getInternalNodeCount() {
        return this.mullabtree.simptree.getInternalNodeCount();
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return this.mullabtree.simptree.getNodeTaxon(nodeRef);
    }

    @Override
    public boolean hasNodeHeights() {
        return true;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return this.mullabtree.simptree.getNodeHeight(nodeRef);
    }

    @Override
    public boolean hasBranchLengths() {
        return true;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        return this.mullabtree.simptree.getBranchLength(nodeRef);
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return this.mullabtree.simptree.getNodeRate(nodeRef);
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        return this.mullabtree.simptree.getNodeAttribute(nodeRef, string);
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return this.mullabtree.simptree.getNodeAttributeNames(nodeRef);
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return this.mullabtree.simptree.isExternal(nodeRef);
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return this.mullabtree.simptree.isRoot(nodeRef);
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        int n = this.mullabtree.simptree.getChildCount(nodeRef);
        assert (n == 2);
        return n;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return this.mullabtree.simptree.getChild(nodeRef, n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return this.mullabtree.simptree.getParent(nodeRef);
    }

    @Override
    public Tree getCopy() {
        return this.mullabtree.simptree.getCopy();
    }

    @Override
    public boolean logNow(long l) {
        if (l == 6696L) {
            System.out.println("logNow(" + l + ")");
        }
        if (l <= 100L) {
            return true;
        }
        if (l <= 10000L) {
            return l % 100L == 0L;
        }
        return l % 10000L == 0L;
    }

    public String testExampleNetworkToMulLabTree(int n) {
        int n2;
        int n3;
        int n4 = this.apsp.numberOfSpecies();
        Taxon[] taxonArray = new Taxon[n4];
        for (int i = 0; i < n4; ++i) {
            taxonArray[i] = new Taxon(this.apsp.apspeciesName(i));
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = 0;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                n5 = 1;
                break;
            }
            case 4: {
                n5 = 2;
                break;
            }
            case 5: {
                n5 = 3;
            }
        }
        this.tettrees = new ArrayList(n5);
        Taxon taxon = new Taxon("L0");
        Taxon taxon2 = new Taxon("L1");
        Taxon taxon3 = new Taxon("L2");
        Taxon taxon4 = new Taxon("R0");
        Taxon taxon5 = new Taxon("R1");
        Taxon taxon6 = new Taxon("R2");
        Taxon[] taxonArray2 = new Taxon[]{taxonArray[1], taxonArray[2], taxonArray[3]};
        Taxon[] taxonArray3 = new Taxon[]{taxonArray[1], taxonArray[2]};
        Taxon[] taxonArray4 = new Taxon[]{taxonArray[1]};
        Taxon[] taxonArray5 = new Taxon[]{taxonArray[2]};
        Taxon[] taxonArray6 = new Taxon[]{taxonArray[3]};
        Taxon[] taxonArray7 = new Taxon[]{};
        switch (n) {
            case 1: {
                this.tettrees.add(new AlloppLeggedTree(taxonArray2));
                d = this.tettrees.get(0).getRootHeight();
                taxonArray7 = new Taxon[]{taxonArray[0], taxon, taxon4, taxonArray[4]};
                break;
            }
            case 2: {
                this.tettrees.add(new AlloppLeggedTree(taxonArray2));
                d = this.tettrees.get(0).getRootHeight();
                taxonArray7 = new Taxon[]{taxonArray[0], taxon, taxon4, taxonArray[4]};
                break;
            }
            case 3: {
                this.tettrees.add(new AlloppLeggedTree(taxonArray2));
                d = this.tettrees.get(0).getRootHeight();
                taxonArray7 = new Taxon[]{taxonArray[0], taxon, taxon4, taxonArray[4]};
                break;
            }
            case 4: {
                this.tettrees.add(new AlloppLeggedTree(taxonArray3));
                this.tettrees.add(new AlloppLeggedTree(taxonArray6));
                d = this.tettrees.get(0).getRootHeight();
                d2 = this.tettrees.get(1).getRootHeight();
                taxonArray7 = new Taxon[]{taxonArray[0], taxon, taxon4, taxon2, taxon5, taxonArray[4]};
                break;
            }
            case 5: {
                this.tettrees.add(new AlloppLeggedTree(taxonArray4));
                this.tettrees.add(new AlloppLeggedTree(taxonArray5));
                this.tettrees.add(new AlloppLeggedTree(taxonArray6));
                d = this.tettrees.get(0).getRootHeight();
                d2 = this.tettrees.get(1).getRootHeight();
                d3 = this.tettrees.get(2).getRootHeight();
                taxonArray7 = new Taxon[]{taxonArray[0], taxon, taxon4, taxon2, taxon5, taxon3, taxon6, taxonArray[4]};
            }
        }
        assert (taxonArray7.length >= 2);
        int n6 = 2 * taxonArray7.length - 1;
        SimpleNode[] simpleNodeArray = new SimpleNode[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            simpleNodeArray[n3] = new SimpleNode();
            if (n3 < taxonArray7.length) {
                simpleNodeArray[n3].setTaxon(taxonArray7[n3]);
                continue;
            }
            simpleNodeArray[n3].setTaxon(new Taxon(""));
        }
        n3 = -1;
        switch (n) {
            case 1: {
                simpleNodeArray[1].setHeight(d + 1.0);
                simpleNodeArray[2].setHeight(d + 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[4], simpleNodeArray[0], simpleNodeArray[1], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[5], simpleNodeArray[2], simpleNodeArray[3], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[6], simpleNodeArray[4], simpleNodeArray[5], 1.0);
                n3 = 6;
                break;
            }
            case 2: {
                simpleNodeArray[1].setHeight(d + 1.0);
                simpleNodeArray[2].setHeight(d + 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[4], simpleNodeArray[0], simpleNodeArray[1], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[5], simpleNodeArray[2], simpleNodeArray[4], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[6], simpleNodeArray[3], simpleNodeArray[5], 1.0);
                n3 = 6;
                break;
            }
            case 3: {
                simpleNodeArray[1].setHeight(d + 1.0);
                simpleNodeArray[2].setHeight(d + 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[4], simpleNodeArray[1], simpleNodeArray[2], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[5], simpleNodeArray[0], simpleNodeArray[4], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[6], simpleNodeArray[3], simpleNodeArray[5], 1.0);
                n3 = 6;
                break;
            }
            case 4: {
                simpleNodeArray[1].setHeight(d + 1.0);
                simpleNodeArray[2].setHeight(d + 1.0);
                simpleNodeArray[3].setHeight(d2 + 1.0);
                simpleNodeArray[4].setHeight(d2 + 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[6], simpleNodeArray[0], simpleNodeArray[1], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[7], simpleNodeArray[3], simpleNodeArray[4], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[8], simpleNodeArray[6], simpleNodeArray[7], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[9], simpleNodeArray[2], simpleNodeArray[5], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[10], simpleNodeArray[8], simpleNodeArray[9], 1.0);
                n3 = 10;
                break;
            }
            case 5: {
                simpleNodeArray[1].setHeight(d + 1.0);
                simpleNodeArray[2].setHeight(d + 1.0);
                simpleNodeArray[3].setHeight(d2 + 1.0);
                simpleNodeArray[4].setHeight(d2 + 1.0);
                simpleNodeArray[5].setHeight(d3 + 1.0);
                simpleNodeArray[6].setHeight(d3 + 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[8], simpleNodeArray[0], simpleNodeArray[1], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[9], simpleNodeArray[5], simpleNodeArray[6], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[10], simpleNodeArray[2], simpleNodeArray[7], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[11], simpleNodeArray[3], simpleNodeArray[8], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[12], simpleNodeArray[4], simpleNodeArray[11], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[13], simpleNodeArray[9], simpleNodeArray[12], 1.0);
                this.addSimpleNodeChildren(simpleNodeArray[14], simpleNodeArray[10], simpleNodeArray[13], 1.0);
                n3 = 14;
            }
        }
        AlloppDiploidHistory alloppDiploidHistory = new AlloppDiploidHistory(simpleNodeArray, n3, this.tettrees, true, this.apsp);
        int n7 = this.numberOfTipPopParameters();
        int n8 = this.numberOfRootPopParameters();
        int n9 = this.maxNumberOfHybPopParameters();
        Parameter.Default default_ = new Parameter.Default(n7);
        Parameter.Default default_2 = new Parameter.Default(n8);
        double[] dArray = new double[n9];
        for (n2 = 0; n2 < n7; ++n2) {
            default_.setParameterValue(n2, 1000 + n2);
        }
        for (n2 = 0; n2 < n8; ++n2) {
            default_2.setParameterValue(n2, 2000 + n2);
        }
        for (n2 = 0; n2 < n9; ++n2) {
            dArray[n2] = 3000 + n2;
        }
        AlloppMulLabTree alloppMulLabTree = new AlloppMulLabTree(alloppDiploidHistory, this.tettrees, this.apsp, default_, default_2, dArray);
        System.out.println(alloppMulLabTree.asText());
        String string = alloppMulLabTree.mullabTreeAsNewick();
        return string;
    }

    void addSimpleNodeChildren(SimpleNode simpleNode, SimpleNode simpleNode2, SimpleNode simpleNode3, double d) {
        simpleNode.addChild(simpleNode2);
        simpleNode.addChild(simpleNode3);
        simpleNode.setHeight(Math.max(simpleNode2.getHeight(), simpleNode3.getHeight()) + d);
    }

    private class TetTreeIndexTrait
    implements TreeTrait<String> {
        TetTreeIndexTrait() {
        }

        @Override
        public String getTraitName() {
            return "tti";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.BRANCH;
        }

        @Override
        public Class getTraitClass() {
            return String.class;
        }

        @Override
        public String getTrait(Tree tree, NodeRef nodeRef) {
            assert (tree == AlloppSpeciesNetworkModel.this.mullabtree);
            return (String)AlloppSpeciesNetworkModel.this.getNodeAttribute(nodeRef, "tti");
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return "" + AlloppSpeciesNetworkModel.this.getNodeAttribute(nodeRef, "tti");
        }

        @Override
        public boolean getLoggable() {
            return true;
        }
    }

    private class HybHeightTrait
    implements TreeTrait<Double> {
        HybHeightTrait() {
        }

        @Override
        public String getTraitName() {
            return "hybhgt";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.NODE;
        }

        @Override
        public Class getTraitClass() {
            return Double.class;
        }

        @Override
        public Double getTrait(Tree tree, NodeRef nodeRef) {
            assert (tree == AlloppSpeciesNetworkModel.this.mullabtree);
            return (Double)AlloppSpeciesNetworkModel.this.getNodeAttribute(nodeRef, "hybhgt");
        }

        @Override
        public String getTraitString(Tree tree, NodeRef nodeRef) {
            return "" + AlloppSpeciesNetworkModel.this.getNodeAttribute(nodeRef, "hybhgt");
        }

        @Override
        public boolean getLoggable() {
            return true;
        }
    }

    private class TetraTaxonGroup {
        ArrayList<Taxon> tettxs = new ArrayList();

        TetraTaxonGroup() {
        }

        public void add(Taxon taxon) {
            this.tettxs.add(taxon);
        }

        public Taxon get(int n) {
            return this.tettxs.get(n);
        }

        public int size() {
            return this.tettxs.size();
        }
    }
}

