/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.alignment.Patterns;
import dr.evolution.datatype.Microsatellite;
import dr.evolution.io.Importer;
import dr.evolution.io.PatternImporter;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MicroSatImporter
implements PatternImporter {
    protected final BufferedReader reader;
    protected String delimiter;
    protected Taxa unionSetTaxonList = new Taxa();
    protected Microsatellite microsatellite;
    protected boolean hasDifferentTaxon = false;

    public MicroSatImporter(BufferedReader bufferedReader) {
        this(bufferedReader, "\t");
    }

    public MicroSatImporter(BufferedReader bufferedReader, String string) {
        this.reader = bufferedReader;
        this.delimiter = string;
    }

    @Override
    public Taxa getUnionSetTaxonList() throws IOException, Importer.ImportException {
        return this.unionSetTaxonList;
    }

    public Microsatellite getMicrosatellite() {
        return this.microsatellite;
    }

    public boolean isHasDifferentTaxon() {
        return this.hasDifferentTaxon;
    }

    @Override
    public List<Patterns> importPatterns() throws IOException, Importer.ImportException {
        Serializable serializable;
        Object object;
        int n;
        ArrayList<Patterns> arrayList = new ArrayList<Patterns>();
        ArrayList arrayList2 = new ArrayList();
        String[] stringArray = new String[2];
        stringArray[1] = "unnamed.microsat";
        String string = this.reader.readLine();
        while (string.startsWith("#")) {
            if (string.toUpperCase().contains("NAME") && ((stringArray = string.trim().split("[" + this.delimiter + " ]+"))[1] == null || stringArray[1].length() < 1)) {
                throw new Importer.ImportException("Improper microsatellite name : " + stringArray[1]);
            }
            string = this.reader.readLine();
        }
        String[] stringArray2 = string.trim().split("[" + this.delimiter + " ]+");
        int n2 = stringArray2.length;
        if (n2 < 2) {
            throw new Importer.ImportException("Import file must have more than 1 columns : " + n2);
        }
        for (n = 0; n < n2; ++n) {
            ArrayList arrayList3 = new ArrayList();
            arrayList2.add(arrayList3);
        }
        n = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        string = this.reader.readLine();
        while (string != null) {
            object = string.trim().split("[" + this.delimiter + " ]+");
            if (((String[])object).length != n2) {
                throw new Importer.ImportException("The number of name columns are different with values columns,\nplease use only letters or numbers in the name.");
            }
            for (int i = 0; i < ((String[])object).length; ++i) {
                int n4;
                ((List)arrayList2.get(i)).add(object[i]);
                if (i <= 0 || (n4 = this.parseInt(object[i])) == Microsatellite.UNKNOWN_STATE_LENGTH) continue;
                if (n > n4) {
                    n = n4;
                }
                if (n3 >= n4) continue;
                n3 = n4;
            }
            string = this.reader.readLine();
        }
        if (n3 < n) {
            throw new Importer.ImportException("Importing invalid data: max < min !");
        }
        this.microsatellite = new Microsatellite(stringArray[1], 1, n3 + 2, 1);
        object = new Taxa();
        for (String string2 : (List)arrayList2.get(0)) {
            serializable = new Taxon(string2);
            ((Taxa)object).addTaxon((Taxon)serializable);
        }
        for (int i = 1; i < arrayList2.size(); ++i) {
            Object object2;
            Taxa taxa = new Taxa();
            if (i + 1 < arrayList2.size() && stringArray2[i].equalsIgnoreCase(stringArray2[i + 1])) {
                Taxon taxon;
                Object object3;
                int n5;
                Taxon taxon2;
                object2 = new Taxa();
                for (String string3 : (List)arrayList2.get(0)) {
                    taxon2 = new Taxon(stringArray2[i] + "_1_" + string3);
                    ((Taxa)object2).addTaxon(taxon2);
                }
                for (String string3 : (List)arrayList2.get(0)) {
                    taxon2 = new Taxon(stringArray2[i] + "_2_" + string3);
                    ((Taxa)object2).addTaxon(taxon2);
                }
                if (this.unionSetTaxonList.containsAny((TaxonList)object2)) {
                    throw new Importer.ImportException("Importing invalid data: duplicate taxon name in this locus : " + stringArray2[i]);
                }
                this.unionSetTaxonList.addTaxa((TaxonList)object2);
                this.hasDifferentTaxon = true;
                serializable = new ArrayList();
                int n6 = ((List)arrayList2.get(i)).size();
                for (n5 = 0; n5 < n6; ++n5) {
                    object3 = (String)((List)arrayList2.get(i)).get(n5);
                    taxon = ((Taxa)object2).getTaxon(n5);
                    if (taxa.contains(taxon)) continue;
                    taxa.addTaxon(taxon);
                    serializable.add(this.parseInt((String)object3));
                    if (this.unionSetTaxonList.contains(taxon)) continue;
                    this.unionSetTaxonList.addTaxon(taxon);
                    if (i <= 1) continue;
                    this.hasDifferentTaxon = true;
                }
                for (n5 = 0; n5 < ((List)arrayList2.get(i + 1)).size(); ++n5) {
                    object3 = (String)((List)arrayList2.get(i + 1)).get(n5);
                    taxon = ((Taxa)object2).getTaxon(n5 + n6);
                    if (taxa.contains(taxon)) continue;
                    taxa.addTaxon(taxon);
                    serializable.add(this.parseInt((String)object3));
                    if (this.unionSetTaxonList.contains(taxon)) continue;
                    this.unionSetTaxonList.addTaxon(taxon);
                    if (i <= 1) continue;
                    this.hasDifferentTaxon = true;
                }
                ++i;
            } else {
                serializable = new ArrayList();
                for (int j = 0; j < ((List)arrayList2.get(i)).size(); ++j) {
                    String string4 = (String)((List)arrayList2.get(i)).get(j);
                    Taxon taxon = ((Taxa)object).getTaxon(j);
                    if (taxa.contains(taxon)) continue;
                    taxa.addTaxon(taxon);
                    serializable.add(this.parseInt(string4));
                    if (this.unionSetTaxonList.contains(taxon)) continue;
                    this.unionSetTaxonList.addTaxon(taxon);
                    if (i <= 1) continue;
                    this.hasDifferentTaxon = true;
                }
            }
            object2 = new int[serializable.size()];
            for (int j = 0; j < serializable.size(); ++j) {
                object2[j] = (Integer)serializable.get(j);
            }
            Patterns patterns = new Patterns(this.microsatellite, taxa);
            patterns.addPattern((int[])object2);
            patterns.setId(stringArray2[i]);
            arrayList.add(patterns);
        }
        return arrayList;
    }

    private int parseInt(String string) {
        if (string.charAt(0) == '?') {
            return Microsatellite.UNKNOWN_STATE_LENGTH;
        }
        return Integer.parseInt(string);
    }

    private boolean isUnknownChar(String string) {
        return this.parseInt(string) == -1;
    }
}

