/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.util.Units;
import dr.math.matrixAlgebra.Vector;

public class MultiEpochExponential
extends ConstantPopulation {
    private final double[] transitionTime;
    private final double[] rate;
    private static final boolean DEBUG = false;

    public MultiEpochExponential(Units.Type type, int n) {
        super(type);
        this.transitionTime = new double[n - 1];
        this.rate = new double[n];
    }

    public void setTransitionTime(int n, double d) {
        this.transitionTime[n] = d;
    }

    public void setGrowthRate(int n, double d) {
        this.rate[n] = d;
    }

    @Override
    public double getDemographic(double d) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < this.transitionTime.length && d > this.transitionTime[n]; ++n) {
            d2 += -this.rate[n] * (this.transitionTime[n] - d3);
            d3 = this.transitionTime[n];
        }
        return this.getN0() * Math.exp(d2 += -this.rate[n] * (d - d3));
    }

    private double integrateConstant(double d, double d2, double d3) {
        double d4 = (d2 - d) / Math.exp(d3);
        return d4;
    }

    private double integrateExponential(double d, double d2, double d3, double d4) {
        double d5 = (Math.exp(d2 * d4) - Math.exp(d * d4)) / Math.exp(d3) / d4;
        return d5;
    }

    public double getAnalyticIntegral(double d, double d2) {
        double d3;
        int n;
        if (d == d2) {
            return 0.0;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n = 0; n < this.transitionTime.length && d > this.transitionTime[n]; ++n) {
            d5 += -this.rate[n] * (this.transitionTime[n] - d6);
            d6 = this.transitionTime[n];
        }
        while (n < this.transitionTime.length && d2 > this.transitionTime[n]) {
            d3 = 0.0;
            if (this.rate[n] == 0.0) {
                d3 = this.integrateConstant(d, this.transitionTime[n], d5);
                d4 += d3;
            } else {
                d3 = this.integrateExponential(d - d6, this.transitionTime[n] - d6, d5, this.rate[n]);
                d4 += d3;
            }
            d5 += -this.rate[n] * (this.transitionTime[n] - d6);
            d = d6 = this.transitionTime[n];
            ++n;
        }
        d3 = 0.0;
        if (this.rate[n] == 0.0) {
            d3 = this.integrateConstant(d, d2, d5);
            d4 += d3;
        } else {
            d3 = this.integrateExponential(d - d6, d2 - d6, d5, this.rate[n]);
            d4 += d3;
        }
        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
            System.err.println(d4 + " " + d + " " + d2 + new Vector(this.rate) + "\n");
        }
        return d4 / this.getN0();
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getAnalyticIntegral(d, d2);
        return d3;
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public int getNumArguments() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public String getArgumentName(int n) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getArgument(int n) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void setArgument(int n, double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getLowerBound(int n) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getUpperBound(int n) {
        throw new RuntimeException("Not implemented!");
    }
}

