/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.WrapperDoubleMatrix1D;

class DelegateDoubleMatrix1D
extends WrapperDoubleMatrix1D {
    protected DoubleMatrix2D content;
    protected int row;

    public DelegateDoubleMatrix1D(DoubleMatrix2D doubleMatrix2D, int n) {
        super(null);
        if (n < 0 || n >= doubleMatrix2D.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(doubleMatrix2D.columns());
        this.row = n;
        this.content = doubleMatrix2D;
    }

    public double getQuick(int n) {
        return this.content.getQuick(this.row, n);
    }

    public DoubleMatrix1D like(int n) {
        return this.content.like1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return this.content.like(n, n2);
    }

    public void setQuick(int n, double d) {
        this.content.setQuick(this.row, n, d);
    }
}

