% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{interpret}
\alias{interpret}
\alias{interpret2}
\title{Interpret ensemble inference and estimates}
\usage{
interpret(inference, samples, specification, method)

interpret2(specification, method = NULL)
}
\arguments{
\item{inference}{model inference created by \link{ensemble_inference}}

\item{samples}{posterior samples created by \link{mix_posteriors}}

\item{specification}{list of lists specifying the generated text.
Each inner list carries: (1) \code{inference} specifying the name of
in the \code{inference} entry and optionally \code{inference_name}
as a name to use in the text and \code{inference_BF_name} as a
symbol to be used instead of the default \code{"BF"}, (2) \code{samples}
specifying the name of in the \code{samples} entry and optionally
\code{samples_name} as a name to use in the text, \code{samples_units} as
a unit text to be appended after the estimate, and \code{samples_conditional}
specifying whether the estimate is conditional or model-averaged.}

\item{method}{character specifying name of the method to be
appended at the beginning of each sentence.}
}
\value{
\code{interpret} returns character.
}
\description{
Provides textual summary for posterior
distributions created by \link{mix_posteriors} and ensemble inference
created by \link{ensemble_inference}.
}
\seealso{
\link{ensemble_inference} \link{mix_posteriors} \link{BayesTools_model_tables} \link{BayesTools_ensemble_tables}
}
