% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/improvement.R
\name{improvement}
\alias{improvement}
\title{BLC: Improvement}
\usage{
improvement(obj, prob = 0.95)
}
\arguments{
\item{obj}{A \code{BLC} object, result of a call to blc() function.}

\item{prob}{A real number that represents the credibility level of the intervals.}
}
\value{
A data.frame with the improvement values of each age, as well as their credible intervals.
}
\description{
Calculates the improvement of each age, based on the resulting chains of the beta parameter from a fitted blc model.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, M = 100, bn = 20)

## Improvement:
improvement(fit)
improvement(fit, prob = 0.9) #90\% credible intervals


}
