% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converge_diag_param_fn.R
\name{converge_diag_param_fn}
\alias{converge_diag_param_fn}
\title{A function to assess convergence of the posterior sampling of fitted parameters for monitoring purposes}
\usage{
converge_diag_param_fn(
  result,
  plot_params = NULL,
  trace = TRUE,
  density = TRUE,
  acf_plot = FALSE,
  ESS_all = FALSE
)
}
\arguments{
\item{result}{object of type either "fit_result" or "BayesMoFo".}

\item{plot_params}{A vector of character strings specifying which set of parameters to plot for visualisation. If not specified, a random selection of the parameters will be included in the plots (see \code{fit_result$param} or \code{runBayesMoFo_result$result$best$param} for a full list) will be chosen. Note that a specific combination of alpha, beta, kappa, and gamma, is to be plotted, then users need to specify the exact indices of them, e.g. \code{plot_params="gamma[1,2]"}. Otherwise, only three randomly selected of them will be plotted. To see a complete list of parameters, i.e. \code{colnames(fit_result$post_sample[[1]])[!startsWith(colnames(fit_result$post_sample[[1]]),"q[")]} or \code{colnames(runBayesMoFo_result$result$best$post_sample[[1]])[!startsWith(colnames(runBayesMoFo_result$result$best$post_sample[[1]]),"q[")]}.}

\item{trace}{A logical value to indicate if trace plots of posterior samples of death rates should be shown (default) or suppressed (e.g. to aid visibility).}

\item{density}{A logical value to indicate if density plots of posterior samples of death rates should be shown (default) or suppressed (e.g. to aid visibility).}

\item{acf_plot}{A logical value to indicate if auto-correlation plots should be shown or suppressed (default).}

\item{ESS_all}{A logical value indicating if effective sample sizes are to be computed for all parameters. The default is FALSE where only chosen parameters will be evaluated, if TRUE all parameters will be assessed.}
}
\value{
Some convergence-related plots of posterior samples of fitted parameters.
\describe{
\item{\code{ESS}}{The effective sample sizes of the chosen parameters.}
}
}
\description{
Produce several convergence diagnostic tools (e.g. trace/density/acf plots and effective sample sizes) from the posterior samples of fitted parameters.
}
\examples{
\donttest{
#load and prepare data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit any mortality model
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="APCI")

#default plot
converge_runBayesMoFo_result<-converge_diag_param_fn(runBayesMoFo_result)

#ESS
converge_runBayesMoFo_result$ESS

#plot specific parameters 

runBayesMoFo_result$result$best$param  #run this line to check parameters of the model
converge_diag_param_fn(runBayesMoFo_result,plot_params=c("rho","sigma2_kappa","beta")) 
#note only three betas were plotted

colnames(runBayesMoFo_result$result$best$post_sample[[1]])[!startsWith(
  colnames(runBayesMoFo_result$result$best$post_sample[[1]]),"q[")]  
#run the above line to check full list of parameters of the model
converge_diag_param_fn(runBayesMoFo_result,plot_params=c("beta[1,2]","gamma[3,2]")) 

#ACF plot 
converge_diag_param_fn(runBayesMoFo_result,plot_params=c("beta[1,2]","gamma[3,2]"),
trace=FALSE,density=FALSE,acf_plot=TRUE)
}
}
\concept{autocorrelations}
\concept{density plots}
\concept{effective sample sizes}
\concept{parameters}
\concept{posterior samples}
\concept{trace plots}
\keyword{bayesian}
\keyword{diagnostics}
\keyword{visualization}
