% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_kfold.R
\name{kfold.ermod}
\alias{kfold.ermod}
\alias{kfold}
\alias{extract_kfold_loo}
\title{Run k-fold cross-validation}
\usage{
\method{kfold}{ermod}(x, k = 5, newdata = NULL, seed = NULL, ...)

kfold(x, ...)

extract_kfold_loo(kfold_ermod)
}
\arguments{
\item{x}{An \code{ermod} object containing the model and data.}

\item{k}{The number of folds for cross-validation. Default is 5.}

\item{newdata}{Optional new dataset to use instead of the original data.
Default is NULL.}

\item{seed}{Random seed for reproducibility. Default is NULL.}

\item{...}{Currently not used.}

\item{kfold_ermod}{An object of class \code{kfold_ermod} from \code{\link[=kfold]{kfold()}}}
}
\value{
\code{\link[=kfold]{kfold()}} returns \code{kfold_ermod} class object containing the fitted
models and holdout predictions for each fold.

\code{\link[=extract_kfold_loo]{extract_kfold_loo()}} returns  \code{c("kfold", "loo")} class object
that works well with \code{loo} ecosystem
}
\description{
This function performs k-fold cross-validation using the appropriate model
development function based on the class of the \code{ermod} object.
It is internally used by \code{\link[=eval_ermod]{eval_ermod()}}. The output is compatible with
\code{loo} ecosystem, e.g. it can be used for \code{\link[loo:loo_compare]{loo::loo_compare()}} function.
See \code{\link[loo:kfold-generic]{loo::kfold()}} for details.
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_eval_mod()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
  # Settings to make the example run faster
  chains = 2,
  iter = 1000
)

cv_results <- kfold(ermod_bin, k = 3, seed = 123)

print(cv_results)
}
\dontshow{\}) # examplesIf}
}
