% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ThetaMatrix.R
\name{create_ThetaMatrix}
\alias{create_ThetaMatrix}
\title{Create Theta Matrix}
\usage{
create_ThetaMatrix(input, output_file = NULL, sigma_s, ...)
}
\arguments{
\item{input}{\link{character} or \link{data.frame} (\emph{optional}): input data frame or file connection
to import a CSV-file with the needed information. If nothing is provided the function returns
an input template. The argument \code{output_file} can be used to write this input template to the file
system}

\item{output_file}{\link{character} (optional): file path for the output CSV-file, the field separator
is hard set to \code{","}. Please use \link[utils:write.table]{utils::write.table} for more flexibility.}

\item{sigma_s}{\link{numeric} (\strong{required}): named character with values for systematic uncertainties. Those values
are lab-specific. Can be set to \code{NULL} to remove systematic uncertainties. The order of the \emph{named}
vector is not important, but the naming!
\strong{Note}: some of the uncertainties have a unit, please check details.}

\item{...}{further arguments that can be passed to \link[utils:read.table]{utils::read.table} (for the CSV-file import)}
}
\value{
A symmetric \eqn{Theta} matrix or if \code{input} is missing, a \link{data.frame} with an input
template
}
\description{
Create the \eqn{\Theta} matrix with the shared uncertainties
that can used as input in, e.g., \link{AgeS_Computation} and \link{Age_OSLC14} which is used for the
covariance matrix \eqn{\Sigma} (Combès & Philippe, 2017)
}
\details{
The function intends to ease the creation of the \eqn{Theta} matrix, which cannot be
created straight forward, e.g., base R functions such as \code{stats::cov}.
The relationship between the covariance matrix  \eqn{Sigma} and \eqn{Theta} is given with

\deqn{\Sigma_ij = A_i * A_j * \Theta_ij}

For details see Combès & Philippe, 2017 and Guérin et al. (2021).

\strong{Input modes}

The function supports two different operation modes:
\enumerate{
\item \code{input} is left empty: the function returns a \link{data.frame} template that can be used as input (the option \code{output_file} works as well)
\item \code{input} is fed with a \link{data.frame} or a \code{character} (file path), the \eqn{\Theta} matrix is returned
}

\strong{Input format}

The function expects either a CSV-file or a \link{data.frame} as input. To create template you can
run the function leaving the argument \code{input} empty (see example). Please note the format
of the input table (\link{data.frame}) needs to kept as specified in the template.

The following table lists the meaning of the columns:

\tabular{lll}{
COLUMN \tab DESCRIPTION \tab UNIT \cr
\code{SAMPLE_ID} \tab sample name \tab - \cr
\code{DR_BETA_K} \tab  standard error beta-dose rate K \tab Gy/ka \cr
\code{DR_BETA_U} \tab  standard error beta-dose rate U \tab Gy/ka \cr
\code{DR_BETA_Th} \tab  standard error beta-dose rate Th \tab Gy/ka \cr
\code{DR_GAMMA_K} \tab  standard error gamma-dose rate K \tab Gy/ka \cr
\code{DR_GAMMA_U} \tab  standard error gamma-dose rate U \tab Gy/ka \cr
\code{DR_GAMMA_Th} \tab  standard error gamma-dose rate Th \tab Gy/ka \cr
\code{DR_GAMMA_TOTAL} \tab  standard error total gamma-dose rate \tab Gy/ka \cr
\code{DR_TOTAL} \tab total dose rate  \tab Gy/ka \cr
\code{DR_TOTAL_X} \tab standard error total dose rate  \tab Gy/ka \cr
}

\emph{Note: All columns can be set to 0 or \code{NA} but no column must be left empty! If a value > 0 is provided
for \code{DR_GAMMA_TOTAL} this value is taken and values in, e.g., \code{DR_GAMMA_K} are discarded (set to 0)!}

\strong{Systematic uncertainties}

The following table provides information on the named argument
that can be provided via the argument \code{sigma_s}. Missing values are not allowed, all
values must be set.

\tabular{lll}{
ARGUMENT \tab DESCRIPTION \tab UNIT \cr
\code{s_betaK} \tab relative uncertainty K concentration \tab - \cr
\code{s_betaU} \tab relative uncertainty U concentration \tab - \cr
\code{s_betaTh} \tab relative uncertainty Th concentration \tab - \cr
\code{s_gammaK} \tab relative uncertainty K concentration \tab - \cr
\code{s_gammaU} \tab relative uncertainty U concentration \tab - \cr
\code{s_gammaTh} \tab relative uncertainty Th concentration \tab - \cr
\code{s_gammaDR} \tab relative uncertainty gamma-dose rate  \tab - \cr
\code{s_CAL} \tab relative uncertainty beta-source calibration \tab - \cr
\code{s_intDR} \tab absolute uncertainty internal dose rate \tab Gy/ka \cr
}
}
\section{Function version}{
 0.1.0
}

\examples{
##(1) return template data.frame (no file output)
create_ThetaMatrix()

\dontrun{
##(2) return template as data.frame + file
file_path <- tempfile(fileext = ".csv")
create_ThetaMatrix(output_file = file_path )

##NOT RUNNING EXAMPLE for sigma_s
calc_ThetaMatrix(...,
sigma_s =  c(
 s_betaK = 0.010,
 s_betaU = 0.007,
 s_betaTh = 0.006,
 s_gammaK = 0.010,
 s_gammaU = 0.007,
 s_gammaTh = 0.006,
 s_gammaDR = 0.05,
 s_CAL = 0.020,
 s_intDR = 0.030))

}



}
\references{
Combès, B., Philippe, A., 2017. Bayesian analysis of individual and systematic multiplicative errors
for estimating ages with stratigraphic constraints in optically stimulated luminescence dating.
Quaternary Geochronology 39, 24–34. \doi{10.1016/j.quageo.2017.02.003}

Guérin, G., Lahaye, C., Heydari, M., Autzen, M., Buylaert, J.-P., Guibert, P., Jain, M., Kreutzer, S., Lebrun, B., Murray, A.S., Thomsen, K.J., Urbanova, P., Philippe, A., 2021. Towards an improvement of optically stimulated luminescence (OSL) age uncertainties: modelling OSL ages with systematic errors, stratigraphic constraints and radiocarbon ages using the R package BayLum. Geochronology 3, 229—245.
\doi{10.5194/gchron-3-229-2021}
}
\seealso{
\link{AgeS_Computation}, \link{Age_OSLC14}, \link[utils:read.table]{utils::read.table}, \link[utils:write.table]{utils::write.table}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, UMR 5060, CNRS-Université Bordeaux Montaigne (France), based
on an 'MS Excel' sheet by Guillaume Guérin, IRAMAT-CRP2A, UMR 5060, CNRS-Université Bordeaux Montaigne (France)
}
\keyword{IO}
\keyword{datagen}
