test_that("ConvertWHAMVThermoFile works", {

  mydbsfile = withr::local_tempfile(fileext = ".dbs")
  write(c(
    "WHAM DATABASE WATER VERSION WATER23.DBS",
    "HA parameters, 3.29E-3, 4.02, 8.55, 1.78, 3.43, -374, 0.5, 1.72E-9,  15000",
    "FA parameters, 4.73E-3, 3.26, 9.64, 3.34, 5.52, -103, 0.4,    8E-10, 1500",
    "Double layer overlap factor, 0.25",
    "Constant to control DDL at low ZED, 1E3",
    "No. of data lines, 234",
    "1,H,            1,  1,0,0,   1,0,0,   999,    0,     999, 999",
    "2,Be,           2,  2,0,0,   1,0,0,   999,    0,     1.7, 0.4",
    "3,Na,           1,  3,0,0,   1,0,0,   999,    0,     999, 999",
    "4,Mg,           2,  4,0,0,   1,0,0,   999,    0,     3.3, 2.2",
    "5,Al,           3,  5,0,0,   1,0,0,   999,    0,     1.3, 0.4",
    "6,K,            1,  6,0,0,   1,0,0,   999,    0,     999, 999",
    "7,Ca,           2,  7,0,0,   1,0,0,   999,    0,     3.2, 2.2",
    "8,CrIII,        3,  8,0,0,   1,0,0,   999,    0,     0.5, 0.1",
    "9,Mn,           2,  9,0,0,   1,0,0,   999,    0,     3.4, 1.7",
    "10,FeII,        2, 10,0,0,   1,0,0,   999,    0,     2.1, 1.3",
    "11,FeIII,       3, 11,0,0,   1,0,0,   999,    0,     0.8,-0.2",
    "12,Co,          2, 12,0,0,   1,0,0,   999,    0,     2.7, 1.7",
    "13,Ni,          2, 13,0,0,   1,0,0,   999,    0,     2.7, 1.4",
    "14,Cu,          2, 14,0,0,   1,0,0,   999,    0,     1.5, 0.8",
    "15,Zn,          2, 15,0,0,   1,0,0,   999,    0,     2.3, 1.3",
    "16,Sr,          2, 16,0,0,   1,0,0,   999,    0,     2.8, 2.3",
    "17,Cd,          2, 17,0,0,   1,0,0,   999,    0,     2.7, 1.5",
    "18,Cs,          1, 18,0,0,   1,0,0,   999,    0,     999, 999",
    "19,Ba,          2, 19,0,0,   1,0,0,   999,    0,     3.6, 2.6",
    "20,Hg,          2, 20,0,0,   1,0,0,   999,    0,     0.2,-0.3",
    "21,Pb,          2, 21,0,0,   1,0,0,   999,    0,     1.7, 0.9",
    "22,UO2,         2, 22,0,0,   1,0,0,   999,    0,     1.3, 0.9",
    "23,UIV,         4, 23,0,0,   1,0,0,   999,    0,     0.0,-0.7",
    "24,PuIII,       3, 24,0,0,   1,0,0,   999,    0,     1.7, 0.8",
    "25,PuIV,        4, 25,0,0,   1,0,0,   999,    0,     0.0,-0.7",
    "26,PuO2,        2, 26,0,0,   1,0,0,   999,    0,     1.6, 0.5",
    "27,Th,          4, 27,0,0,   1,0,0,   999,    0,     0.6,-0.4",
    "28,Am,          3, 28,0,0,   1,0,0,   999,    0,     1.2, 0.3",
    "29,NH4,         1, 29,0,0,   1,0,0,   999,    0,     999, 999",
    "30,Cm,          3, 30,0,0,   1,0,0,   999,    0,     2.0, 1.6",
    "31,Li,          1, 31,0,0,   1,0,0,   999,    0,     999, 999",
    "32,Eu,          3, 32,0,0,   1,0,0,   999,    0,     1.3, 0.2",
    "33,CeIII,       3, 33,0,0,   1,0,0,   999,    0,     1.8, 0.8",
    "34,Ag,          1, 34,0,0,   1,0,0,   999,    0,     2.4, 1.7",
    "51,OH,         -1, 51,0,0,   1,0,0,   999,    0,     999, 999",
    "52,Cl,         -1, 52,0,0,   1,0,0,   999,    0,     999, 999",
    "53,NO3,        -1, 53,0,0,   1,0,0,   999,    0,     999, 999",
    "54,SO4,        -2, 54,0,0,   1,0,0,   999,    0,     999, 999",
    "55,CO3,        -2, 55,0,0,   1,0,0,   999,    0,     999, 999",
    "56,F,          -1, 56,0,0,   1,0,0,   999,    0,     999, 999",
    "57,PO4,        -3, 57,0,0,   1,0,0,   999,    0,     999, 999",
    "58,SHA,        -1, 58,0,0,   1,0,0,   999,    0,     999, 999",
    "59,SFA,        -1, 59,0,0,   1,0,0,   999,    0,     999, 999",
    "60,S,          -2, 60,0,0,   1,0,0,   999,    0,     999, 999",
    "101,HCO3,      -1,  1,55,0,  1,1,0,  10.329, -3.561, 999, 999",
    "102,H2CO3,      0,  1,55,0,  2,1,0,  16.681, -5.738, 999, 999",
    "104,HF,         0,  1,56,0,  1,1,0,   3.18,   3.18,  999, 999",
    "105,HPO4,      -2,  1,57,0,  1,1,0,  12.35,  -3.5,   999, 999",
    "106,H2PO4,     -1,  1,57,0,  2,1,0,  19.55,  -4.3,   999, 999",
    "107,H3PO4,      0,  1,57,0,  3,1,0,  21.70,  -2.4,   999, 999",
    "108,HS,        -1,  1,60,0,  1,1,0,  13.9,    0.0,   999, 999",
    "109,H2S,        0,  1,60,0,  2,1,0,  20.9,    0.0,   999, 999",
    "113,BeOH,       1,  2,51,0,  1,1,0,   8.6,    0.0,   1.7, 0.4",
    "114,Be(OH)2,    0,  2,51,0,  1,2,0,  14.35,   0.0,   999, 999",
    "115,Be(OH)3,   -1,  2,51,0,  1,3,0,  18.75,   0.0,   999, 999",
    "116,Be(OH)4,   -2,  2,51,0,  1,4,0,  18.59,   0.0,   999, 999",
    "117,BeSO4,      0,  2,54,0,  1,1,0,   1.95,   0.0,   999, 999",
    "118,BeF,        1,  2,56,0,  1,1,0,   5.2,    0.0,   999, 999",
    "124,MgHCO3,     1,  4,1,55,  1,1,1,  11.40,  -2.77,  999, 999",
    "125,MgCO3,      0,  4,55,0,  1,1,0,   2.98,   2.71,  999, 999",
    "126,MgSO4,      0,  4,54,0,  1,1,0,   2.37,   4.55,  999, 999",
    "127,MgHPO4,     0,  4,1,57,  1,1,1,  15.26,  -0.5,   999, 999",
    "133,AlOH,       2,  5,51,0,  1,1,0,   9.01,  -1.54,  1.3, 0.4",
    "134,Al(OH)2,    1,  5,51,0,  1,2,0,  17.87,  -3.68,  999, 999",
    "135,Al(OH)4,   -1,  5,51,0,  1,4,0,  33.84, -10.86,  999, 999",
    "136,AlSO4,      1,  5,54,0,  1,1,0,   3.20,   2.3,   999, 999",
    "137,AlF,        2,  5,56,0,  1,1,0,   6.98,   0.7,   999, 999",
    "138,AlF2,       1,  5,56,0,  1,2,0,  12.60,   2.0,   999, 999",
    "139,AlF3,       0,  5,56,0,  1,3,0,  16.65,   2.2,   999, 999",
    "145,CaHCO3,     1,  7,1,55,  1,1,1,  11.44,  -0.87,  999, 999",
    "146,CaCO3,      0,  7,55,0,  1,1,0,   3.22,   3.55,  999, 999",
    "147,CaSO4,      0,  7,54,0,  1,1,0,   2.30,   1.65,  999, 999",
    "148,CaHPO4,     0,  7,1,57,  1,1,1,  15.09,  -0.5,   999, 999",
    "154,CrOH,       2,  8,51,0,  1,1,0,  10.0,    0.0,   0.5, 0.1",
    "155,Cr(OH)2,    1,  8,51,0,  1,2,0,  18.3,    0.0,   999, 999",
    "156,Cr(OH)3,    0,  8,51,0,  1,3,0,  24.0,    0.0,   999, 999",
    "157,Cr(OH)4,   -1,  8,51,0,  1,4,0,  28.6,    0.0,   999, 999",
    "158,CrSO4,      1,  8,54,0,  1,1,0,   2.0,    2.0,   999, 999",
    "159,CrF,        2,  8,56,0,  1,1,0,   5.2,    2.0,   999, 999",
    "165,MnOH,       1,  9,51,0,  1,1,0,   3.41,   1.04,  3.4, 1.7",
    "166,MnSO4,      0,  9,54,0,  1,1,0,   2.25,   3.37,  999, 999",
    "167,MnCO3,      0,  9,55,0,  1,1,0,   4.52,   0.0,   999, 999",
    "168,MnCl,       1,  9,52,0,  1,1,0,   0.61,   0.0,   999, 999",
    "169,MnHPO4,     0,  9,1,57,  1,1,1,  15.93,   0.0,   999, 999",
    "170,MnHCO3,     1,  9,1,55,  1,1,1,  12.28,   0.0,   999, 999",
    "175,FeOH,       1, 10,51,0,  1,1,0,   4.5,   -0.2,   2.1, 1.3",
    "176,FeSO4,      0, 10,54,0,  1,1,0,   2.25,   3.23,  999, 999",
    "177,FeCO3,      0, 10,55,0,  1,1,0,   5.31,   0.0,   999, 999",
    "178,FeHPO4,     0, 10,1,57,  1,1,1,  15.95,   0.0,   999, 999",
    "179,FeCl,       1, 10,52,0,  1,1,0,   0.14,   0.0,   999, 999",
    "180,FeHCO3,     1, 10,1,55,  1,1,1,  12.33,   0.0,   999, 999",
    "185,FeOH,       2, 11,51,0,  1,1,0,  11.81,  -2.96,  0.8,-0.2",
    "186,Fe(OH)2,    1, 11,51,0,  1,2,0,  22.33,  -9.62,  999, 999",
    "187,Fe(OH)3,    0, 11,51,0,  1,3,0,  29.44, -15.29,  999, 999",
    "188,Fe(OH)4,   -1, 11,51,0,  1,4,0,  34.4,  -21.55,  999, 999",
    "190,FeSO4,      1, 11,54,0,  1,1,0,   4.04,   3.91,  999, 999",
    "191,FeF,        2, 11,56,0,  1,1,0,   6.2,    2.7,   999, 999",
    "192,FeF2,       1, 11,56,0,  1,2,0,  10.8,    4.8,   999, 999",
    "193,FeHPO4,     1, 11,1,57,  1,1,1,  21.55,   0,     999, 999",
    "194,FeCl,       2, 11,52,0,  1,1,0,   1.48,   5.6,   999, 999",
    "195,FeCl2,      1, 11,52,0,  1,2,0,   2.13,   0.0,   999, 999",
    "201,CoOH,       1, 12,51,0,  1,1,0,   4.35,   0.0,   2.7, 1.7",
    "202,Co(OH)2,    0, 12,51,0,  1,2,0,   9.2,    0.0,   999, 999",
    "203,CoSO4,      0, 12,54,0,  1,1,0,   2.36,   1.4,   999, 999",
    "204,CoCO3,      0, 12,55,0,  1,1,0,   5.53,   0.0,   999, 999",
    "205,CoCl,       1, 12,52,0,  1,1,0,   0.3,    0.5,   999, 999",
    "206,CoHCO3,     1, 12,1,55,  1,1,1,  13.22,   0.0,   999, 999",
    "211,NiOH,       1, 13,51,0,  1,1,0,   4.14,   0.0,   2.7, 1.4",
    "212,Ni(OH)2,    0, 13,51,0,  1,2,0,   9.0,    0.0,   999, 999",
    "213,NiSO4,      0, 13,54,0,  1,1,0,   2.32,   1.5,   999, 999",
    "214,NiCO3,      0, 13,55,0,  1,1,0,   5.78,   0.0,   999, 999",
    "215,NiCl,       1, 13,52,0,  1,1,0,   0.4,    0.5,   999, 999",
    "216,NiHCO3,     1, 13,1,55,  1,1,1,  13.41,   0.0,   999, 999",
    "221,CuOH,       1, 14,51,0,  1,1,0,   6.48,   0.0,   1.5, 0.8",
    "222,Cu(OH)2,    0, 14,51,0,  1,2,0,  11.78,   0.0,   999, 999",
    "223,CuSO4,      0, 14,54,0,  1,1,0,   2.36,   2.1,   999, 999",
    "224,CuCO3,      0, 14,55,0,  1,1,0,   6.75,   0.0,   999, 999",
    "225,Cu(CO3)2,  -2, 14,55,0,  1,2,0,   9.92,   0.0,   999, 999",
    "226,CuCl,       1, 14,52,0,  1,1,0,   0.4,    1.6,   999, 999",
    "227,CuHCO3,     1, 14,1,55,  1,1,1,  14.62,   0.0,   999, 999",
    "232,ZnOH,       1, 15,51,0,  1,1,0,   5.04,   0.0,   2.3, 1.3",
    "233,Zn(OH)2,    0, 15,51,0,  1,2,0,  11.1,    0.0,   999, 999",
    "234,ZnSO4,      0, 15,54,0,  1,1,0,   2.38,   1.5,   999, 999",
    "235,ZnCO3,      0, 15,55,0,  1,1,0,   4.76,   0.0,   999, 999",
    "236,ZnCl,       1, 15,52,0,  1,1,0,   0.4,    1.3,   999, 999",
    "237,ZnHCO3,     1, 15,1,55,  1,1,1,  13.12,   0.0,   999, 999",
    "242,SrSO4,      0, 16,54,0,  1,1,0,   2.29,   2.08,  999, 999",
    "243,SrCO3,      0, 16,55,0,  1,1,0,   2.81,   5.22,  999, 999",
    "244,SrHCO3,     1, 16,1,55,  1,1,1,  11.51,   2.49,  999, 999",
    "249,CdOH,       1, 17,51,0,  1,1,0,   3.92,   0.0,   2.7, 1.5",
    "250,Cd(OH)2,    0, 17,51,0,  1,2,0,   7.65,   0.0,   999, 999",
    "251,CdSO4,      0, 17,54,0,  1,1,0,   2.46,   2.3,   999, 999",
    "252,CdCl,       1, 17,52,0,  1,1,0,   1.98,   0.3,   999, 999",
    "253,CdCl2,      0, 17,52,0,  1,2,0,   2.6,    0.9,   999, 999",
    "259,BaSO4,      0, 19,54,0,  1,1,0,   2.7,    0.0,   999, 999",
    "260,BaCO3,      0, 19,55,0,  1,1,0,   2.71,   3.55,  999, 999",
    "261,BaHCO3,     1, 19,1,55,  1,1,1,  11.31,   2.00,  999, 999",
    "266,HgOH,       1, 20,51,0,  1,1,0,  10.60,  -5.8,   0.2,-0.3",
    "267,Hg(OH)2,    0, 20,51,0,  1,2,0,  21.83, -16.2,   999, 999",
    "268,Hg(OH)3,   -1, 20,51,0,  1,3,0,  20.9,  -20.0,   999, 999",
    "269,HgSO4,      0, 20,54,0,  1,1,0,   2.0,    0.0,   999, 999",
    "270,HgCl,       1, 20,52,0,  1,1,0,   7.21,  -4.8,   999, 999",
    "271,HgCl2,      0, 20,52,0,  1,2,0,  13.98, -12.8,   999, 999",
    "272,HgCl3,     -1, 20,52,0,  1,3,0,  15.06, -15.0,   999, 999",
    "273,HgCl4,     -2, 20,52,0,  1,4,0,  15.42, -14.9,   999, 999",
    "279,PbOH,       1, 21,51,0,  1,1,0,   6.29,   0.0,   1.7, 0.9",
    "280,Pb(OH)2,    0, 21,51,0,  1,2,0,  10.88,   0.0,   999, 999",
    "281,Pb(OH)3,   -1, 21,51,0,  1,3,0,  13.94,   0.0,   999, 999",
    "282,PbSO4,      0, 21,54,0,  1,1,0,   2.75,   0.0,   999, 999",
    "283,PbCO3,      0, 21,55,0,  1,1,0,   7.2,    0.0,   999, 999",
    "284,Pb(CO3)2,  -2, 21,55,0,  1,2,0,  10.5,    0.0,   999, 999",
    "285,PbCl,       1, 21,52,0,  1,1,0,   1.59,   4.4,   999, 999",
    "286,PbCl2,      0, 21,52,0,  1,2,0,   1.8,    0.0,   999, 999",
    "292,UO2OH,      1, 22,51,0,  1,1,0,   8.8,   -2.6,   1.3, 0.9",
    "293,UO2(OH)2,   0, 22,51,0,  1,2,0,  16.1,    0.0,   999, 999",
    "294,UO2(OH)3,  -1, 22,51,0,  1,3,0,  21.0,    0.0,   999, 999",
    "295,(UO2)2(OH)2,2, 22,51,0,  2,2,0,  22.4,  -17.1,   999, 999",
    "296,(UO2)3(OH)5,1, 22,51,0,  3,5,0,  54.3,  -42.7,   999, 999",
    "297,UO2SO4,     0, 22,54,0,  1,1,0,   3.0,    0.0,   999, 999",
    "298,UO2CO3,     0, 22,55,0,  1,1,0,   9.4,    1.1,   999, 999",
    "299,UO2(CO3)2, -2, 22,55,0,  1,2,0,  16.4,    3.5,   999, 999",
    "305,UOH,        3, 23,51,0,  1,1,0,  13.3,   -7.0,   0.0,-0.7",
    "306,U(OH)2,     2, 23,51,0,  1,2,0,  24.7,  -14.0,   999, 999",
    "307,U(OH)3,     1, 23,51,0,  1,3,0,  34.2,  -21.0,   999, 999",
    "308,U(OH)4,     0, 23,51,0,  1,4,0,  41.7,  -28.7,   999, 999",
    "309,U(OH)5,    -1, 23,51,0,  1,5,0,  47.3,  -39.2,   999, 999",
    "310,UF,         3, 23,56,0,  1,1,0,   8.65,   0.0,   999, 999",
    "311,UF2,        2, 23,56,0,  1,2,0,  14.47,   0.0,   999, 999",
    "312,USO4,       2, 23,54,0,  1,1,0,   6.11,   0.0,   999, 999",
    "313,UCl,        3, 23,52,0,  1,1,0,   1.16,   0.0,   999, 999",
    "317,PuOH,       2, 24,51,0,  1,1,0,   6.8,    0.0,   1.7, 0.8",
    "318,Pu(OH)2,    1, 24,51,0,  1,2,0,  12.12,   0.0,   999, 999",
    "319,PuCO3,      1, 24,55,0,  1,1,0,   9.6,    0.0,   999, 999",
    "320,Pu(CO3)2,  -1, 24,55,0,  1,2,0,  12.9,    0.0,   999, 999",
    "321,PuSO4,      1, 24,54,0,  1,1,0,   3.34,   0.0,   999, 999",
    "322,PuCl,       2, 24,52,0,  1,1,0,   1.12,   0.0,   999, 999",
    "328,PuOH,       3, 25,51,0,  1,1,0,  13.30,   0.0,   0.0,-0.7",
    "329,Pu(OH)2,    2, 25,51,0,  1,2,0,  28.14,   0.0,   999, 999",
    "330,Pu(OH)3,    1, 25,51,0,  1,3,0,  39.11,   0.0,   999, 999",
    "331,Pu(OH)4,    0, 25,51,0,  1,4,0,  46.81,   0.0,   999, 999",
    "332,PuSO4,      2, 25,54,0,  1,1,0,   6.42,   0.0,   999, 999",
    "333,Pu(SO4)2,   0, 25,54,0,  1,2,0,  10.78,   0.0,   999, 999",
    "334,PuCl,       3, 25,52,0,  1,1,0,   1.22,   0.0,   999, 999",
    "335,PuCO3,      2, 25,55,0,  1,1,0,  19.14,   0.0,   999, 999",
    "336,Pu(CO3)2,   0, 25,55,0,  1,2,0,  33.12,   0.0,   999, 999",
    "342,PuO2OH,     1, 26,51,0,  1,1,0,   8.3,    0.0,   1.6, 0.5",
    "343,PuO2(OH)2,  0, 26,51,0,  1,2,0,  16.85,   0.0,   999, 999",
    "344,PuO2(OH)3, -1, 26,51,0,  1,3,0,  20.88,   0.0,   999, 999",
    "345,PuO2CO3,    0, 26,55,0,  1,1,0,  12.0,    0.0,   999, 999",
    "346,PuO2(CO3)2,-2, 26,55,0,  1,2,0,  14.9,    0.0,   999, 999",
    "347,PuO2Cl,     1, 26,52,0,  1,1,0,   0.63,   0.0,   999, 999",
    "348,PuO2SO4,    0, 26,52,0,  1,2,0,   4.68,   0.0,   999, 999",
    "354,ThOH,       3, 27,51,0,  1,1,0,  11.66,  -7.4,   0.6,-0.4",
    "355,Th(OH)2,    2, 27,51,0,  1,2,0,  21.64, -12.75,  999, 999",
    "356,Th(OH)3,    1, 27,51,0,  1,3,0,  30.3,  -19.67,  999, 999",
    "357,Th(OH)4,    0, 27,51,0,  1,4,0,  40.1,  -34.7,   999, 999",
    "358,ThF,        3, 27,56,0,  1,1,0,   8.44,   0.0,   999, 999",
    "359,ThF2,       2, 27,56,0,  1,2,0,  15.06,   0.0,   999, 999",
    "360,ThCO3,      2, 27,55,0,  1,1,0,  11.03,   0.0,   999, 999",
    "361,ThCl,       3, 27,52,0,  1,1,0,   1.18,   0.0,   999, 999",
    "367,AmOH,       2, 28,51,0,  1,1,0,   6.73,   0.0,   1.2, 0.3",
    "368,Am(OH)2,    1, 28,51,0,  1,2,0,  12.04,   0.0,   999, 999",
    "369,Am(OH)3,    0, 28,51,0,  1,3,0,  17.84,   0.0,   999, 999",
    "370,Am(OH)4,   -1, 28,51,0,  1,4,0,  16.0,    0.0,   999, 999",
    "371,AmCO3,      1, 28,55,0,  1,1,0,   7.42,   0.0,   999, 999",
    "372,Am(CO3)2,  -1, 28,55,0,  1,2,0,  11.86,   0.0,   999, 999",
    "378,EuOH,       2, 32,51,0,  1,1,0,   6.2,    0.0,   1.3, 0.2",
    "379,Eu(OH)2,    1, 32,51,0,  1,2,0,  11.8,    0.0,   999, 999",
    "380,Eu(OH)3,    0, 32,51,0,  1,3,0,  17,      0.0,   999, 999",
    "381,Eu(OH)4,   -1, 32,51,0,  1,4,0,  19,      0.0,   999, 999",
    "382,EuCO3,      1, 32,55,0,  1,1,0,   8.26,   0.0,   999, 999",
    "383,Eu(CO3)2,  -1, 32,55,0,  1,2,0,  14.18,   0.0,   999, 999",
    "384,EuSO4,      1, 32,54,0,  1,1,0,   3.67,   4.9,   999, 999",
    "390,CeOH,       2, 33,51,0,  1,1,0,   5.7,    0.0,   1.8, 0.8",
    "391,Ce(OH)2,    1, 33,51,0,  1,2,0,  11.8,    0.0,   999, 999",
    "392,Ce(OH)3,    0, 33,51,0,  1,3,0,  17,      0.0,   999, 999",
    "393,Ce(OH)4,   -1, 33,51,0,  1,4,0,  19,      0.0,   999, 999",
    "394,CeCO3,      1, 33,55,0,  1,1,0,   8.26,   0.0,   999, 999",
    "395,Ce(CO3)2,  -1, 33,55,0,  1,2,0,  14.18,   0.0,   999, 999",
    "396,CeSO4,      1, 33,54,0,  1,1,0,   3.59,   4.6,   999, 999",
    "397,Ag(OH),     0, 34,51,0,  1,1,0,   2.00,   0.0,   999, 999",
    "398,Ag(OH)2,   -1, 34,51,0,  1,2,0,   3.99,   0.0,   999, 999",
    "399,Ag(Cl),     0, 34,52,0,  1,1,0,   3.31,  -3.0,   999, 999",
    "400,Ag(Cl)2,   -1, 34,52,0,  1,2,0,   5.25,  -4.0,   999, 999",
    "401,Ag(Cl)3,   -2, 34,52,0,  1,3,0,   5.20,  -9.3,   999, 999",
    "402,Ag(Cl)4,   -3, 34,52,0,  1,4,0,   5.51,   0.0,   999, 999",
    "403,Ag(NO3),    0, 34,53,0,  1,1,0,  -0.10,   0.0,   999, 999",
    "404,Ag(SHA),    0, 34,58,0,  1,1,0,  12.00,   0.0,   999, 999",
    "405,Ag(SFA),    0, 34,59,0,  1,1,0,  12.00,   0.0,   999, 999",
    "406,AgHS,       0, 34,1,60,  1,1,1,  27.28,   0.0,   999, 999",
    "407,ZnS,        0, 15,60,0,  1,1,0,  18.29,   0.0,   999, 999",
    "408,Cu(SHA),    0, 14,58,0,  1,1,0,  12.30,   0.0,   999, 999",
    "409,Cu(SFA),    0, 14,59,0,  1,1,0,  12.30,   0.0,   999, 999",
    "410,Ag(HS)2,    0, 34,1,60,  1,2,2,  47.27,   0.0,   999, 999",
    "END OF DATA",
    "/*"
  ), file = mydbsfile)

  expect_no_error({
    converted.file = ConvertWHAMVThermoFile(ThermoDBSName = mydbsfile)
  })

  previously.converted.file = BLMEngineInR::All_WATER23_reactions
  compare.names = setdiff(names(previously.converted.file), c("ParamFile","WHAM"))
  expect_equal(object = converted.file[compare.names],
               expected = previously.converted.file[compare.names])

  # testthat::skip_on_cran()
  compare.names = setdiff(names(previously.converted.file), c("Ver","File"))
  expect_equal(object = converted.file$WHAM[compare.names],
               expected = previously.converted.file$WHAM[compare.names])
})
