% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoichConversionFunctions.R
\name{StoichConversionFunctions}
\alias{StoichConversionFunctions}
\alias{StoichCompsToStoichMatrix}
\alias{StoichCompsToEquation}
\alias{StoichMatrixToEquation}
\alias{EquationToStoichMatrix}
\alias{StoichMatrixToStoichComps}
\alias{EquationToStoichComps}
\alias{EquationToStoich}
\title{Stoichiometry conversion functions}
\usage{
StoichCompsToStoichMatrix(
  SpecCompNames = list(),
  SpecCompStoichs = list(),
  CompName = unique(unlist(SpecCompNames)),
  SpecName = names(SpecCompNames),
  SpecNC = as.integer(sapply(SpecCompNames, function(X) {
     sum(X != "")
 }))
)

StoichCompsToEquation(
  SpecCompNames = list(),
  SpecCompStoichs = list(),
  CompName = unique(unlist(SpecCompNames)),
  SpecName = names(SpecCompNames),
  SpecNC = as.integer(sapply(SpecCompNames, function(X) {
     sum(X != "")
 }))
)

StoichMatrixToEquation(
  SpecStoich = matrix(),
  SpecName = rownames(SpecStoich),
  CompName = colnames(SpecStoich)
)

EquationToStoichMatrix(SpecEquation = character(), CompName)

StoichMatrixToStoichComps(SpecStoich = matrix(), CompName)

EquationToStoichComps(SpecEquation = character(), CompName)

EquationToStoich(SpecEquation = character(), CompName)
}
\arguments{
\item{SpecCompNames}{a list object where each element is a vector of
component names in a formation reaction.}

\item{SpecCompStoichs}{a list object where each element is a vector of the
stoichiometric coefficients in the formation reaction corresponding to the
components in `SpecCompNames`.}

\item{CompName}{a character vector of the component names, in order. These
are the columns of the `SpecStoich` matrix.}

\item{SpecName}{a character vector of the chemical species names, in order.
These are the rows of the `SpecStoich` matrix.}

\item{SpecNC}{an integer vector giving the number of reactants in each
formation reaction.}

\item{SpecStoich}{A matrix of stoichiometric coefficients, where each row
corresponds to a chemical species and each column corresponds to a
component.}

\item{SpecEquation}{A character vector giving the chemical equation for a
formation reaction. This must include the stoichiometric coefficients for
each reactant, even if it's 1. (e.g., the equation for the formation of
calcium chloride would be `"CaCl2 = 1 * Ca + 2 * Cl"`).}
}
\value{
`XToStoichMatrix` returns `SpecStoich`, `XToEquation` returns
  `SpecEquation`, and `XToStoichComps` returns a list with at least the two
  items `SpecCompNames` and `SpecCompStoichs`. `EquationToStoich`
}
\description{
These functions help with converting between equations (the
  intuitive way people think about formation reactions), stoichiometric
  matrices (what CHESS needs to define the problem), and paired lists of
  component names and stoichiometries (how parameter files define formation
  reactions).
}
\details{
The naming scheme of these functions is simple
}
\keyword{internal}
