% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSex.R
\name{repairSex}
\alias{repairSex}
\title{Repairs Sex Coding in a Pedigree Dataframe}
\usage{
repairSex(ped, verbose = FALSE, code_male = NULL, code_female = NULL)
}
\arguments{
\item{ped}{A dataframe representing the pedigree data with a 'sex' column.}

\item{verbose}{A logical flag indicating whether to print progress and validation messages to the console.}

\item{code_male}{The current code used to represent males in the 'sex' column.}

\item{code_female}{The current code used to represent females in the 'sex' column. If both are NULL, no recoding is performed.}
}
\value{
A modified version of the input data.frame \code{ped}, containing an additional or modified 'sex_recode' column where the 'sex' values are recoded according to \code{code_male}. NA values in the 'sex' column are preserved.
}
\description{
This function serves as a wrapper around `checkSex` to specifically handle
the repair of the sex coding in a pedigree dataframe.
}
\details{
The validation process identifies:
- The unique sex codes present in the dataset.
- Whether individuals listed as fathers or mothers have inconsistent sex codes.
- Instances where an individual's recorded sex does not align with their parental role.

If `repair = TRUE`, the function standardizes sex coding by:
- Assigning individuals listed as fathers the most common male code in the dataset.
- Assigning individuals listed as mothers the most common female code.

This function uses the terms 'male' and 'female' in a biological context, referring to chromosomal and other biologically-based characteristics necessary for constructing genetic pedigrees. The biological aspect of sex used in genetic analysis (genotype) is distinct from the broader, richer concept of gender identity (phenotype).

We recognize the importance of using language and methodologies that affirm and respect the full spectrum of gender identities.  The developers of this
package express unequivocal support for folx in the transgender
and LGBTQ+ communities.
}
\examples{
\dontrun{
ped <- data.frame(ID = c(1, 2, 3), sex = c("M", "F", "M"))
repairSex(ped, code_male = "M", verbose = TRUE)
}
}
\seealso{
\code{\link{checkSex}}
}
