% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPedigreeNetwork.R
\name{checkPedigreeNetwork}
\alias{checkPedigreeNetwork}
\title{Validate Pedigree Network Structure}
\usage{
checkPedigreeNetwork(
  ped,
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  verbose = FALSE
)
}
\arguments{
\item{ped}{Dataframe representing the pedigree.}

\item{personID}{Character. Column name for individual IDs.}

\item{momID}{Character. Column name for maternal IDs.}

\item{dadID}{Character. Column name for paternal IDs.}

\item{verbose}{Logical. If TRUE, print informative messages.}
}
\value{
List containing detailed validation results.
}
\description{
Checks for structural issues in pedigree networks, including:
- Individuals with more than two parents.
- Presence of cyclic parent-child relationships.
}
\examples{
\dontrun{
results <- checkPedigreeNetwork(ped,
  personID = "ID",
  momID = "momID", dadID = "dadID", verbose = TRUE
)
}
}
