% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_functions.R
\name{alloc.simple}
\alias{alloc.simple}
\title{Simple allocation function}
\usage{
alloc.simple(m, prob)
}
\arguments{
\item{m}{the 'BATSS' ingredient '\code{m}', a scalar corresponding to the number of participants to be allocated.}

\item{prob}{the 'BATSS' ingredient '\code{prob}', a named vector of allocation ratios or probabilities.}
}
\value{
\link{alloc.simple} returns an object of class \link[base]{factor} of length '\code{m}' with levels matching the names of the vector '\code{prob}'.
}
\description{
\link{alloc.simple} independently randomises each unit to a group (i.e., flips a coin for each unit) so that the observed allocation probabilities may be far from the target ones. This strategy is often considered to be a poor choice.
}
\examples{
alloc.simple(100, prob = c(A=.4,B=.6))
table(alloc.simple(100, prob = c(A=.4,B=.6)))
table(alloc.simple(100, prob = c(A=.4,B=.6)))
}
\seealso{
\code{\link[=alloc.balanced]{alloc.balanced()}}, another group allocation function.
}
