% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{copy_to.kusto_database_endpoint}
\alias{copy_to.kusto_database_endpoint}
\title{This function uploads a local data frame into a remote data source, creating the table definition as needed.
If the table exists, it will append the data to the existing table. If not, it will create a new table.}
\usage{
\method{copy_to}{kusto_database_endpoint}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  method = "inline",
  ...
)
}
\arguments{
\item{dest}{remote data source}

\item{df}{local data frame}

\item{name}{Name for new remote table}

\item{overwrite}{If \code{TRUE}, will overwrite an existing table with
name \code{name}. If \code{FALSE}, will throw an error if \code{name} already
exists.}

\item{method}{For local ingestion, the method to use. "inline", "streaming", or "indirect".}

\item{...}{other parameters passed to the query}
}
\description{
This function uploads a local data frame into a remote data source, creating the table definition as needed.
If the table exists, it will append the data to the existing table. If not, it will create a new table.
}
\seealso{
\code{\link[dplyr:compute]{dplyr::collect()}} for the opposite action; downloading remote data into a local tbl.
}
