% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_node_size_boxplot.R
\name{Af_node_size_boxplot}
\alias{Af_node_size_boxplot}
\title{Function to make a grouped boxplot of the normalized average node sizes (number of cells with the exact same sequence) from specific groups of lineage trees constructed with AntibodyForests.}
\usage{
Af_node_size_boxplot(
  AntibodyForests_object,
  min.nodes,
  groups,
  node.feature,
  colors,
  text.size,
  x.label,
  group.order,
  significance,
  parallel,
  output.file
)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{min.nodes}{The minimum number of nodes for a tree to be included in this analysis (this included the germline)}

\item{groups}{Which groups to compare. These groups need to be in the node features of the AntibodyForests-object. Set to NA if all features should displayed. (default is NA)
If you want to compare IgM and IgG for example, groups should be c("IgM, "IgG") (not "Isotypes")}

\item{node.feature}{Node feature in the AntibodyForests-object to compare.}

\item{colors}{Optionally specific colors for the group (Will be matched to the groups/names on alphabetical order).}

\item{text.size}{Font size in the plot (default 20).}

\item{x.label}{Label for the x-axis (default is the node feature).}

\item{group.order}{Order of the groups on the x-axis. (default is alphabetical/numerical)}

\item{significance}{If TRUE, the significance of the difference (paired t-test) between the groups is plotted. (default FALSE)}

\item{parallel}{If TRUE, the metric calculations are parallelized across clonotypes. (default FALSE)}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A ggplot2 object with the boxplot.
}
\description{
Function to compare trees.
}
\examples{
Af_node_size_boxplot(AntibodyForests::small_af,
                    min.nodes = 5,
                    groups = c("IGHA", "IgG1"),
                    node.feature = "isotype")

}
