% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullIbdHaplo}
\alias{pullIbdHaplo}
\title{Pull IBD haplotypes}
\usage{
pullIbdHaplo(pop, chr = NULL, snpChip = NULL, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosomes are retrieved.}

\item{snpChip}{an integer indicating which SNP array loci 
are to be retrieved. If NULL, all sites are retrieved.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a matrix of IBD haplotypes.
}
\description{
Retrieves IBD haplotype data
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
SP$addSnpChip(5)
SP$setTrackRec(TRUE)

#Create population
pop = newPop(founderPop, simParam=SP)
pullIbdHaplo(pop, simParam=SP)

}
