#' Phenotypic data for loblolly pine dataset
#'
#' Deregressed estimated breeding values (DEBV) for the trait diameter at breast height (DBH)
#' at 6 years of age from trees grown at site Nassau.
#' The dataset contains a total of 861 genotypes of loblolly pine
#' (\emph{Pinus taeda} L.).
#' Dataset obtained from supplementary material in Resende \emph{et al.} (2012).
#'
#' @docType data
#'
#' @usage pheno.pine
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @references
#' Resende, M.F.R., Munoz, P. Resende, M.D.V., Garrick, D.J., Fernando, R.L., Davis, J.M.,
#' Jokela, E.J., Martin, T.A., Peter, G.F., and Kirst, M. 2012. Accuracy of genomic
#' selection methods in a standard data set of loblolly pine (\emph{Pinus taeda} L.).
#' Genetics 190:1503-1510.
#'
#' @examples
#' pheno.pine |> head()
#'
#' @name pheno.pine
NULL
