##################################################
#' Air Quality Evaluation
##################################################
#'
#' R AQEval: R code for the analysis of discrete
#' change in Air Quality time-series.
#'
#' @section AQEval:
#' \code{AQEval} was developed for use by those tasked with
#' the routine detection, characterisation and quantification
#' of discrete changes in air quality time-series.
#'
#' The main functions, \code{\link{quantBreakPoints}}
#' and \code{\link{quantBreakSegments}}, use
#' break-point/segment (BP/S) methods
#' based on the consecutive use of methods in the
#' \code{strucchange} and \code{segmented} \code{R} packages
#' to first detection (as break-points) and then characterise
#' and quantify (as segments), discrete changes in
#' air-quality time-series.
#'
#' \code{AQEval} functions adopt an \code{openair}-friendly
#' approach using function and data structures that many
#' in the air quality research community are already familiar
#' with.
#' Most notably, most functions expect supplied data
#' to be time-series, to be supplied as a single
#' \code{data.frame} (or similar R object), and for
#' time-series to be identified by column names.
#' The main functions are typically structured expect
#' first the \code{data.frame}, then the name of the
#' pollutant to be used, then other arguments:
#'
#' \code{function(data, "polluant.name", ...)}
#'
#' \code{output <- function(data, "polluant.name", ...)}
#'
#' @seealso
#'
#' For more about data structure and an example data set,
#' see \code{\link{AQEval.data}}
#'
#' For more about the main functions, see
#' \code{\link{quantBreakPoints}}
#' and \code{\link{quantBreakSegments}}
#' @author Karl Ropkins
#' @references
#' Ropkins, K. and Tate, J.E., 2021. Early observations on the impact of the
#' COVID-19 lockdown on air quality trends across the UK. Science of the
#' Total Environment, 754, p.142374.
#' https://doi.org/10.1016/j.scitotenv.2020.142374
#'
#' Ropkins, K., Tate, J.E., Walker, A. and Clark, T., 2022. Measuring the
#' impact of air quality related interventions. Environmental Science:
#' Atmospheres, 2(3), pp.500-516. https://doi.org/10.1039/d1ea00073j
#'
#' Ropkins, K., Walker, A., Philips, I., Rushton, C., Clark, T. and
#' Tate, J., Change Detection of Air Quality Time-Series Using the
#' R Package AEQval. Available at SSRN 4267722.
#' https://ssrn.com/abstract=4267722 or http://dx.doi.org/10.2139/ssrn.4267722
#' Also at: https://karlropkins.github.io/AQEval/articles/AQEval_Intro_Preprint.pdf
#'
#' @name AQEval-package
#' @aliases AQEval
#' "_PACKAGE"
NULL
