% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_isolates}
\alias{example_isolates}
\title{Data Set with 2 000 Example Isolates}
\format{
A \link[tibble:tibble]{tibble} with 2 000 observations and 46 variables:
\itemize{
\item \code{date}\cr Date of receipt at the laboratory
\item \code{patient}\cr ID of the patient
\item \code{age}\cr Age of the patient
\item \code{gender}\cr Gender of the patient, either "F" or "M"
\item \code{ward}\cr Ward type where the patient was admitted, either "Clinical", "ICU", or "Outpatient"
\item \code{mo}\cr ID of microorganism created with \code{\link[=as.mo]{as.mo()}}, see also the \link{microorganisms} data set
\item \code{PEN:RIF}\cr 40 different antimicrobials with class \code{\link{sir}} (see \code{\link[=as.sir]{as.sir()}}); these column names occur in the \link{antimicrobials} data set and can be translated with \code{\link[=set_ab_names]{set_ab_names()}} or \code{\link[=ab_name]{ab_name()}}
}
}
\usage{
example_isolates
}
\description{
A data set containing 2 000 microbial isolates with their full antibiograms. This data set contains randomised fictitious data, but reflects reality and can be used to practise AMR data analysis. For examples, please read \href{https://amr-for-r.org/articles/AMR.html}{the tutorial on our website}.
}
\section{Download Our Reference Data}{

All reference data sets in the AMR package - including information on microorganisms, antimicrobials, and clinical breakpoints - are freely available for download in multiple formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, and Stata.

For maximum compatibility, we also provide machine-readable, tab-separated plain text files suitable for use in any software, including laboratory information systems.

Visit \href{https://amr-for-r.org/articles/datasets.html}{our website for direct download links}, or explore the actual files in \href{https://github.com/msberends/AMR/tree/main/data-raw/datasets}{our GitHub repository}.
}

\examples{
example_isolates
}
\keyword{datasets}
