% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ss_mean}
\alias{ss_mean}
\title{Compute mean}
\usage{
ss_mean(
  data,
  name,
  vars,
  max_na = NULL,
  exclude = NULL,
  events = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. The name of the summary score.}

\item{vars}{character vector. The names of the columns to be summarized.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed (Default: NULL; no restriction on missing values).}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{events}{character (vector). Only compute the summary score for the
specified events (Default: NULL; computed for all events).}

\item{combine}{logical. Whether to combine the summary score column with the
input data frame (Default: TRUE).}
}
\value{
tbl. The input data frame with the summary score appended as a new
column.
}
\description{
Computes the mean of a set of variables, with the option to exclude certain
values (for non-responses like "Don't know"/"Decline to answer") and to set
a maximum number of missing values.
}
\examples{
data <- tibble::tribble(
  ~session_id, ~a, ~b,  ~c,  ~d,  ~e,
  "ses-00A",   1,  1,   1,   1,   NA,
  "ses-01A",   2,  777, 2,   2,   2,
  "ses-02A",   3,  3,   999, 3,   3,
  "ses-02A",   4,  4,   4,   777, NA,
  "ses-03A",   5,  NA,  777, 999, 5,
  "ses-03A",   NA, NA,  NA,  NA,  NA,
  "ses-04A",   1,  NA,  NA,  NA,  NA
)

data |>
  ss_mean(
    name = "mean",
    vars = c("a", "b", "c", "d", "e"),
    max_na = 1,
    exclude = c("777", "999")
  )

data |>
  ss_mean(
    name = "mean",
    vars = c("a", "b", "c", "d", "e"),
    max_na = 1,
    exclude = c("777", "999"),
    combine = FALSE
  )

data |>
  ss_mean(
    name = "mean",
    vars = c("a", "b", "c", "d", "e"),
    max_na = NULL,
    exclude = NULL,
    events = c("ses-00A", "ses-01A"),
  )
}
