% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_su.R
\docType{data}
\name{vars_su_y_alchss}
\alias{vars_su_y_alchss}
\alias{compute_su_y_alchss_sum}
\title{Compute "Alcohol Hangover Symptoms Scale (HSS) [Youth]: Sum"}
\format{
vars_su_y_alchss is a table of all column names
used to compute summary score of \code{su_y_alchss}.
}
\usage{
vars_su_y_alchss

compute_su_y_alchss_sum(
  data,
  name = "su_y_alchss_sum",
  max_na = 0,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{max_na}{integer, Maximum number of missing values allowed in the
summary score.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{su_y_alchss_sum}
Alcohol Hangover Symptoms Scale (HSS) [Youth]: Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{su_y_alchss_001}
\item \code{su_y_alchss_002}
\item \code{su_y_alchss_003}
\item \code{su_y_alchss_004}
\item \code{su_y_alchss_005}
\item \code{su_y_alchss_006}
\item \code{su_y_alchss_007}
\item \code{su_y_alchss_008}
\item \code{su_y_alchss_009}
\item \code{su_y_alchss_010}
\item \code{su_y_alchss_011}
\item \code{su_y_alchss_012}
\item \code{su_y_alchss_013}
\item \code{su_y_alchss_014}
\item \code{su_y_alchss_001__l}
\item \code{su_y_alchss_002__l}
\item \code{su_y_alchss_003__l}
\item \code{su_y_alchss_004__l}
\item \code{su_y_alchss_005__l}
\item \code{su_y_alchss_006__l}
\item \code{su_y_alchss_007__l}
\item \code{su_y_alchss_008__l}
\item \code{su_y_alchss_009__l}
\item \code{su_y_alchss_010__l}
\item \code{su_y_alchss_011__l}
\item \code{su_y_alchss_012__l}
\item \code{su_y_alchss_013__l}
\item \code{su_y_alchss_014__l}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} maximally 0 of 2 items missing
}
}
\examples{
\dontrun{
compute_su_y_alchss_sum(data)
}
}
\keyword{datasets}
