% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\docType{data}
\name{vars_mh_y_pps__bother}
\alias{vars_mh_y_pps__bother}
\alias{compute_mh_y_pps__bother_nm}
\title{Compute "Prodromal Psychosis Scale [Youth] (Bother responses): Number
missing"}
\format{
vars_mh_y_pps__bother is a character vector of all
column names used to compute summary of \code{mh_y_pps__bother} scores.
}
\usage{
vars_mh_y_pps__bother

compute_mh_y_pps__bother_nm(data, name = "mh_y_pps__bother_nm", combine = TRUE)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\description{
Computes the summary score \code{mh_y_pps__bother_nm}
Prodromal Psychosis Scale [Youth] (Bother responses): Number missing
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_pps__bother_001}
\item \code{mh_y_pps__bother_002}
\item \code{mh_y_pps__bother_003}
\item \code{mh_y_pps__bother_004}
\item \code{mh_y_pps__bother_005}
\item \code{mh_y_pps__bother_006}
\item \code{mh_y_pps__bother_007}
\item \code{mh_y_pps__bother_008}
\item \code{mh_y_pps__bother_009}
\item \code{mh_y_pps__bother_010}
\item \code{mh_y_pps__bother_011}
\item \code{mh_y_pps__bother_012}
\item \code{mh_y_pps__bother_013}
\item \code{mh_y_pps__bother_014}
\item \code{mh_y_pps__bother_015}
\item \code{mh_y_pps__bother_016}
\item \code{mh_y_pps__bother_017}
\item \code{mh_y_pps__bother_018}
\item \code{mh_y_pps__bother_019}
\item \code{mh_y_pps__bother_020}
\item \code{mh_y_pps__bother_021}
}
}
}
\details{
The number of missing values in the \code{mh_y_pps__bother} score is
calculated by subtracting the number of valid pairs from the total
PPS count for each subject (mh_y_pps_count - bother_pair_good_sum).

A good pair is defined as a pair where the \code{mh_y_pps_count} is 1 and
the \code{mh_y_pps__bother} is not missing.
}
\examples{
\dontrun{
compute_mh_y_pps__bother_nm(data) |>
  select(
    any_of(c("mh_y_pps__bother_nm", vars_mh_y_pps__bother))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_pps_count]{compute_mh_y_pps_count()}}
}
\keyword{datasets}
