% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\docType{data}
\name{vars_mh_p_asr__critic}
\alias{vars_mh_p_asr__critic}
\alias{compute_mh_p_asr__critic_nm}
\title{Compute "Adult Self Report [Parent] (Critical Items): Number missing"}
\format{
\code{vars_mh_p_asr__critic} is vector of all column names
used to compute summary score of \code{mh_p_asr__critic} scores.
}
\usage{
vars_mh_p_asr__critic

compute_mh_p_asr__critic_nm(
  data,
  name = "mh_p_asr__critic_nm",
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_asr__critic_nm}
Adult Self Report [Parent] (Critical Items): Number missing
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_asr__aggr_001}
\item \code{mh_p_asr__aggr__antsoc_003}
\item \code{mh_p_asr__aggr__antsoc_006}
\item \code{mh_p_asr__aggr__antsoc_008}
\item \code{mh_p_asr__anxdep__dep_001}
\item \code{mh_p_asr__anxdep__dep_004}
\item \code{mh_p_asr__anxdep__dep_005}
\item \code{mh_p_asr__attn__inatt_002}
\item \code{mh_p_asr__othpr__hypimp_001}
\item \code{mh_p_asr__othpr__antsoc_001}
\item \code{mh_p_asr__rule_001}
\item \code{mh_p_asr__rule_003}
\item \code{mh_p_asr__rule__antsoc_007}
\item \code{mh_p_asr__tho_001}
\item \code{mh_p_asr__tho_002}
\item \code{mh_p_asr__tho_005}
\item \code{mh_p_asr__tho_006}
\item \code{mh_p_asr__tho_007}
\item \code{mh_p_asr__tho__dep_001}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
}
}
\examples{
\dontrun{
compute_mh_p_asr__critic_nm(data) |>
  select(
    any_of(c("mh_p_asr__critic_nm", vars_mh_p_asr__critic))
  )
}
}
\keyword{datasets}
