/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.StamenTileSource;

public class Demo
extends JFrame {
    private static final long serialVersionUID = 1L;

    public Demo() {
        super("JMapViewer Demo");
        JComboBox<TileLoader> jComboBox;
        this.setSize(400, 400);
        final JMapViewer jMapViewer = new JMapViewer(new MemoryTileCache(), 4);
        this.setLayout(new BorderLayout());
        this.setExtendedState(6);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "South");
        JLabel jLabel = new JLabel("Use right mouse button to move the map,\n left double click or mouse wheel to zoom.");
        jPanel2.add(jLabel);
        JButton jButton = new JButton("setDisplayToFitMapMarkers");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jMapViewer.setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> jComboBox2 = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.MapnikBw(), new OsmTileSource.MapToolKitTopo(), new OsmTileSource.Waze(), new BingAerialTileSource(), new StamenTileSource.Toner(), new StamenTileSource.Terrain(), new StamenTileSource.WaterColor(), new OsmTileSource.MapnikGerman(), new OsmTileSource.Wanderreitkarte(), new OsmTileSource.MapBox(), new OsmTileSource.Esri(), new OsmTileSource.EsriTopo(), new OsmTileSource.Nps(), new OsmTileSource.Apple(), new OsmTileSource.Skobbler(), new OsmTileSource.HillShade(), new OsmTileSource.CycleMap(), new OsmTileSource.BBBikeGerman(), new OsmTileSource.BBBike(), new OsmTileSource.PublicTransport(), new OsmTileSource.Transport(), new OsmTileSource.UrlTileSource(null)});
        jComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                jMapViewer.setTileSource((TileSource)itemEvent.getItem());
            }
        });
        try {
            jComboBox = new JComboBox<TileLoader>(new TileLoader[]{new OsmFileCacheTileLoader(jMapViewer), new OsmTileLoader(jMapViewer)});
        }
        catch (IOException iOException) {
            jComboBox = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader(jMapViewer)});
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                jMapViewer.setTileLoader((TileLoader)itemEvent.getItem());
            }
        });
        jMapViewer.setTileLoader((TileLoader)jComboBox.getSelectedItem());
        jPanel.add(jComboBox2);
        jPanel.add(jComboBox);
        final JCheckBox jCheckBox = new JCheckBox("Map markers visible");
        jCheckBox.setSelected(jMapViewer.getMapMarkersVisible());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jMapViewer.setMapMarkerVisible(jCheckBox.isSelected());
            }
        });
        jPanel.add(jCheckBox);
        final JCheckBox jCheckBox2 = new JCheckBox("Tile grid visible");
        jCheckBox2.setSelected(jMapViewer.isTileGridVisible());
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jMapViewer.setTileGridVisible(jCheckBox2.isSelected());
            }
        });
        jPanel.add(jCheckBox2);
        final JCheckBox jCheckBox3 = new JCheckBox("Show zoom controls");
        jCheckBox3.setSelected(jMapViewer.getZoomContolsVisible());
        jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jMapViewer.setZoomContolsVisible(jCheckBox3.isSelected());
            }
        });
        jPanel.add(jCheckBox3);
        jPanel.add(jButton);
        final JTextField jTextField = new JTextField(30);
        jPanel2.add(jTextField);
        new DefaultMapController(jMapViewer){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                jTextField.setText(this.map.getToolTipText(mouseEvent));
            }
        };
        this.add((Component)jMapViewer, "Center");
    }

    public static void main(String[] stringArray) {
        new Demo().setVisible(true);
    }
}

